<p align="center">
  <a href="https://saasify.sh" title="Saasify">
    <img src="https://raw.githubusercontent.com/saasify-sh/saasify/master/logo-vert-white@4x.png" alt="Saasify Logo" width="256" />
  </a>
</p>

# saasify-openapi-utils

> OpenAPI utilities for [Saasify](https://saasify.sh).

[![NPM](https://img.shields.io/npm/v/saasify-openapi-utils.svg)](https://www.npmjs.com/package/saasify-openapi-utils) [![Build Status](https://travis-ci.com/saasify-sh/saasify.svg?branch=master)](https://travis-ci.com/saasify-sh/saasify) [![JavaScript Style Guide](https://img.shields.io/badge/code_style-standard-brightgreen.svg)](https://standardjs.com)

## Install

```bash
npm install --save saasify-openapi-utils
```

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

- [annotate-openapi](#annotate-openapi)
- [process-readme](#process-readme)
- [convert-openapi-to-services](#convert-openapi-to-services)
- [parse-openapi](#parse-openapi)
- [openapi-service-params-to-json-schema](#openapi-service-params-to-json-schema)
- [service-to-path-item](#service-to-path-item)
- [path-to-service](#path-to-service)

### [annotate-openapi](https://git@github.com/:saasify-sh/saasify/blob/c7da0aa6bbb907086d7876e1e222f4c945f29bd6/packages/saasify-openapi-utils/lib/annotate-openapi.js#L19-L181)

Annotates a valid OpenAPI spec with extra metadata specific to Saasify's SaaS web client
and [Redoc](https://github.com/Redocly/redoc).

Type: `function (spec, deployment, opts): Promise`

- `spec` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** OpenAPI spec.
- `deployment` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Parent Saasify deployment.
- `opts` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)?** Optional config. (optional, default `{}`)

---

### [process-readme](https://git@github.com/:saasify-sh/saasify/blob/c7da0aa6bbb907086d7876e1e222f4c945f29bd6/packages/saasify-openapi-utils/lib/process-readme.js#L18-L58)

Pre-processes a markdown readme for display in Saasify's Redoc docs.

Type: `function (rawReadme): string`

- `rawReadme` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Raw markdown readme string.

---

### [convert-openapi-to-services](https://git@github.com/:saasify-sh/saasify/blob/c7da0aa6bbb907086d7876e1e222f4c945f29bd6/packages/saasify-openapi-utils/lib/convert-openapi-to-services.js#L11-L56)

Converts an OpenAPI spec to Saasify's `Service` format.

Type: `function (openapi, config): Promise`

- `openapi` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** OpenAPI spec.
- `config` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Parsed Saasify project configuration.

---

### [parse-openapi](https://git@github.com/:saasify-sh/saasify/blob/c7da0aa6bbb907086d7876e1e222f4c945f29bd6/packages/saasify-openapi-utils/lib/parse-openapi.js#L32-L88)

Validates and parses an OpenAPI spec according to Saasify's constraints.

Returns a potentially updated, deep cloned spec that should be used.

Type: `function (spec): Promise`

- `spec` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** OpenAPI spec.

---

### [openapi-service-params-to-json-schema](https://git@github.com/:saasify-sh/saasify/blob/c7da0aa6bbb907086d7876e1e222f4c945f29bd6/packages/saasify-openapi-utils/lib/openapi-service-params-to-json-schema.js#L20-L86)

Converts an OpenAPI-based Service's input parameters into a corresponding
JSON Schema.

Type: `function (service, openapi): Promise`

- `service` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Service to convert.
- `openapi` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** OpenAPI spec for the parent deployment.

---

### [service-to-path-item](https://git@github.com/:saasify-sh/saasify/blob/c7da0aa6bbb907086d7876e1e222f4c945f29bd6/packages/saasify-openapi-utils/lib/service-to-path-item.js#L6-L12)

Finds the OpenAPI PathItem that corresponds to a particular service.

Type: `function (service, openapi)`

- `service`
- `openapi`

---

### [path-to-service](https://git@github.com/:saasify-sh/saasify/blob/c7da0aa6bbb907086d7876e1e222f4c945f29bd6/packages/saasify-openapi-utils/lib/path-to-service.js#L6-L12)

Finds the service that corresponds with a particular relative URL path.

Type: `function (path, deployment)`

- `path`
- `deployment`

---

## Related

- [saasify](https://saasify.sh) - Saasify is the easiest way to launch your own SaaS.

## License

MIT © [Saasify](https://saasify.sh)
