# Snapshot report for `lib/parse-openapi.test.js`

The actual snapshot is saved in `parse-openapi.test.js.snap`.

Generated by [AVA](https://avajs.dev).

## parseOpenAPI error google-webfonts-swagger-2

> Snapshot 1

    'Invalid OpenAPI spec must provide "openapi" version'

## parseOpenAPI error invalid-path

> Snapshot 1

    'Invalid path "foo" must start with "/"'

## parseOpenAPI success basic

> Snapshot 1

    {
      info: {
        title: 'Fast API',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/': {
          get: {
            operationId: 'read_root__get',
            parameters: [
              {
                in: 'query',
                name: 'q',
                required: false,
                schema: {
                  title: 'Q',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
            },
            summary: 'Read Root',
          },
        },
      },
    }

## parseOpenAPI success examples-get-params-0

> Snapshot 1

    {
      info: {
        description: 'Should output an object with default values from get.parameters',
        title: 'Fixture Examples',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'foo',
                required: true,
                schema: {
                  example: 'foo',
                  title: 'foo',
                  type: 'string',
                },
              },
              {
                example: 'bar',
                in: 'query',
                name: 'bar',
                schema: {
                  title: 'bar',
                  type: 'string',
                },
              },
              {
                examples: {
                  foo: {
                    value: 'baz0',
                  },
                },
                in: 'query',
                name: 'baz0',
                schema: {
                  title: 'baz0',
                  type: 'string',
                },
              },
              {
                examples: [
                  'baz1',
                ],
                in: 'query',
                name: 'baz1',
                schema: {
                  title: 'baz1',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'abc0',
                schema: {
                  examples: {
                    foo: {
                      value: 'abc0',
                    },
                  },
                  title: 'abc0',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'abc1',
                schema: {
                  examples: [
                    'abc1',
                  ],
                  title: 'abc1',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'nala',
                schema: {
                  default: 13,
                  title: 'nala',
                  type: 'number',
                },
              },
              {
                in: 'query',
                name: 'blank',
                schema: {
                  description: 'shouldn\'t show up in examples',
                  title: 'blank',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
            },
          },
        },
      },
    }

## parseOpenAPI success examples-get-params-1

> Snapshot 1

    {
      info: {
        description: 'Should output an object with default values from get.parameters and op.parameters',
        title: 'Fixture Examples',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/': {
          get: {
            parameters: [
              {
                examples: {
                  foo: {
                    value: 'baz0',
                  },
                },
                in: 'query',
                name: 'baz0',
                schema: {
                  title: 'baz0',
                  type: 'string',
                },
              },
              {
                examples: [
                  'baz1',
                ],
                in: 'query',
                name: 'baz1',
                schema: {
                  title: 'baz1',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'abc0',
                schema: {
                  examples: {
                    foo: {
                      value: 'abc0',
                    },
                  },
                  title: 'abc0',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'abc1',
                schema: {
                  examples: [
                    'abc1',
                  ],
                  title: 'abc1',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'nala',
                schema: {
                  default: 13,
                  title: 'nala',
                  type: 'number',
                },
              },
              {
                in: 'query',
                name: 'blank',
                schema: {
                  description: 'shouldn\'t show up in examples',
                  title: 'blank',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
            },
          },
          parameters: [
            {
              in: 'query',
              name: 'foo',
              required: true,
              schema: {
                example: 'foo',
                title: 'foo',
                type: 'string',
              },
            },
            {
              example: 'bar',
              in: 'query',
              name: 'bar',
              schema: {
                title: 'bar',
                type: 'string',
              },
            },
          ],
        },
      },
    }

## parseOpenAPI success examples-get-params-2

> Snapshot 1

    {
      info: {
        description: 'Missing required parameter baz0 so should output []',
        title: 'Fixture Examples',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'baz0',
                required: true,
                schema: {
                  title: 'baz0',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
            },
          },
          parameters: [
            {
              in: 'query',
              name: 'foo',
              required: true,
              schema: {
                example: 'foo',
                title: 'foo',
                type: 'string',
              },
            },
            {
              example: 'bar',
              in: 'query',
              name: 'bar',
              schema: {
                title: 'bar',
                type: 'string',
              },
            },
          ],
        },
      },
    }

## parseOpenAPI success examples-post-request-body-0

> Snapshot 1

    {
      info: {
        description: 'Should output an example list of ingredients',
        title: 'Zestful',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/parseIngredients': {
          post: {
            description: 'Parses a list of raw ingredient strings into structured JSON.',
            requestBody: {
              content: {
                'application/json': {
                  example: {
                    ingredients: [
                      '3 large Granny Smith apples',
                      '2 1/2 tablespoons finely chopped parsley',
                      '½ tsp brown sugar',
                    ],
                  },
                  schema: {
                    additionalProperties: false,
                    properties: {
                      ingredients: {
                        description: `List of ingredients to parse.␊
                        - This list must contain between 1 and 100 elements.␊
                        - Each string in the list must be 1,024 characters or fewer.␊
                        - Unicode strings are supported.␊
                        - The strings may be HTML- or URL-encoded.␊
                        - Any HTML tags in the ingredient strings will be ignored.`,
                        items: {
                          type: 'string',
                        },
                        title: 'ingredients',
                        type: 'array',
                      },
                    },
                    required: [
                      'ingredients',
                    ],
                    type: 'object',
                  },
                },
              },
            },
            summary: 'Parse Ingredients',
          },
        },
      },
    }

## parseOpenAPI success examples-post-request-body-1

> Snapshot 1

    {
      info: {
        description: 'Should output an example list of ingredients (aggregated)',
        title: 'Zestful',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/parseIngredients': {
          post: {
            description: 'Parses a list of raw ingredient strings into structured JSON.',
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    additionalProperties: false,
                    example: {
                      ingredients: [
                        '3 large Granny Smith apples',
                        '2 1/2 tablespoons finely chopped parsley',
                        '½ tsp brown sugar',
                      ],
                    },
                    properties: {
                      ingredients: {
                        description: `List of ingredients to parse.␊
                        - This list must contain between 1 and 100 elements.␊
                        - Each string in the list must be 1,024 characters or fewer.␊
                        - Unicode strings are supported.␊
                        - The strings may be HTML- or URL-encoded.␊
                        - Any HTML tags in the ingredient strings will be ignored.`,
                        items: {
                          type: 'string',
                        },
                        title: 'ingredients',
                        type: 'array',
                      },
                    },
                    required: [
                      'ingredients',
                    ],
                    type: 'object',
                  },
                },
              },
            },
            summary: 'Parse Ingredients',
          },
        },
      },
    }

## parseOpenAPI success examples-post-request-body-2

> Snapshot 1

    {
      info: {
        description: 'Should output an example list of ingredients (aggregated)',
        title: 'Zestful',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/parseIngredients': {
          post: {
            description: 'Parses a list of raw ingredient strings into structured JSON.',
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    additionalProperties: false,
                    properties: {
                      ingredients: {
                        description: `List of ingredients to parse.␊
                        - This list must contain between 1 and 100 elements.␊
                        - Each string in the list must be 1,024 characters or fewer.␊
                        - Unicode strings are supported.␊
                        - The strings may be HTML- or URL-encoded.␊
                        - Any HTML tags in the ingredient strings will be ignored.`,
                        example: [
                          '3 large Granny Smith apples',
                          '2 1/2 tablespoons finely chopped parsley',
                          '½ tsp brown sugar',
                        ],
                        items: {
                          type: 'string',
                        },
                        title: 'ingredients',
                        type: 'array',
                      },
                    },
                    required: [
                      'ingredients',
                    ],
                    type: 'object',
                  },
                },
              },
            },
            summary: 'Parse Ingredients',
          },
        },
      },
    }

## parseOpenAPI success examples-post-request-body-3

> Snapshot 1

    {
      info: {
        description: 'Should output an example list of ingredients (aggregated, deduped)',
        title: 'Zestful',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/parseIngredients': {
          post: {
            description: 'Parses a list of raw ingredient strings into structured JSON.',
            requestBody: {
              content: {
                'application/json': {
                  example: {
                    ingredients: [
                      '3 large Granny Smith apples',
                      '2 1/2 tablespoons finely chopped parsley',
                      '½ tsp brown sugar',
                    ],
                  },
                  schema: {
                    additionalProperties: false,
                    properties: {
                      ingredients: {
                        description: `List of ingredients to parse.␊
                        - This list must contain between 1 and 100 elements.␊
                        - Each string in the list must be 1,024 characters or fewer.␊
                        - Unicode strings are supported.␊
                        - The strings may be HTML- or URL-encoded.␊
                        - Any HTML tags in the ingredient strings will be ignored.`,
                        example: [
                          '3 large Granny Smith apples',
                          '2 1/2 tablespoons finely chopped parsley',
                          '½ tsp brown sugar',
                        ],
                        items: {
                          type: 'string',
                        },
                        title: 'ingredients',
                        type: 'array',
                      },
                    },
                    required: [
                      'ingredients',
                    ],
                    type: 'object',
                  },
                },
              },
            },
            summary: 'Parse Ingredients',
          },
        },
      },
    }

## parseOpenAPI success examples-post-request-body-4

> Snapshot 1

    {
      info: {
        description: 'Should output an example list of ingredients (aggregated, unique). Should have two examples as output',
        title: 'Zestful',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/parseIngredients': {
          post: {
            description: 'Parses a list of raw ingredient strings into structured JSON.',
            requestBody: {
              content: {
                'application/json': {
                  example: {
                    ingredients: [
                      '2 tall apples',
                      '1 tiny kitten',
                      '½ tsp brown sugar',
                    ],
                  },
                  schema: {
                    additionalProperties: false,
                    properties: {
                      ingredients: {
                        description: `List of ingredients to parse.␊
                        - This list must contain between 1 and 100 elements.␊
                        - Each string in the list must be 1,024 characters or fewer.␊
                        - Unicode strings are supported.␊
                        - The strings may be HTML- or URL-encoded.␊
                        - Any HTML tags in the ingredient strings will be ignored.`,
                        example: [
                          '3 large Granny Smith apples',
                          '2 1/2 tablespoons finely chopped parsley',
                          '½ tsp brown sugar',
                        ],
                        items: {
                          type: 'string',
                        },
                        title: 'ingredients',
                        type: 'array',
                      },
                    },
                    required: [
                      'ingredients',
                    ],
                    type: 'object',
                  },
                },
              },
            },
            summary: 'Parse Ingredients',
          },
        },
      },
    }

## parseOpenAPI success icons8

> Snapshot 1

    {
      components: {
        requestBodies: {
          Body: {
            content: {
              'application/json': {
                schema: {
                  example: {
                    auth: {
                      hash: 'api-demo-user',
                    },
                    task: {
                      arguments: {
                        collection: 'bef787ce-41ad-4424-8e0e-19ce78e104c3',
                        css_prefix: 'icons8',
                        css_rules_case: 'lowercase',
                        css_selector: '.icons8-{{glyph}}',
                        font_name: 'Material Very Basic',
                      },
                    },
                  },
                  properties: {
                    auth: {
                      properties: {
                        hash: {
                          description: 'Authorization hash',
                          type: 'string',
                        },
                      },
                      required: [
                        'hash',
                      ],
                      type: 'object',
                    },
                    task: {
                      properties: {
                        arguments: {
                          properties: {
                            collection: {
                              description: 'collection identifier',
                              type: 'string',
                            },
                            css_prefix: {
                              default: 'icons8',
                              description: 'prefix for CSS rules, used to generate LESS/SCSS',
                              type: 'string',
                            },
                            css_rules_case: {
                              default: 'lowercase',
                              description: 'glyph names conversion rule',
                              enum: [
                                'lowercase',
                                'as_is',
                              ],
                              type: 'string',
                            },
                            css_selector: {
                              default: '.icons8-{{glyph}}',
                              description: 'template for glyph selector; placeholder {{glyph}} will be replaced with glyph names',
                              type: 'string',
                            },
                            font_name: {
                              default: 'font_icons8',
                              description: 'name of iconic webfont',
                              type: 'string',
                            },
                          },
                          required: [
                            'collection',
                            'font_name',
                          ],
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                  type: 'object',
                },
              },
            },
          },
        },
        schemas: {
          AuthArgument: {
            properties: {
              hash: {
                description: 'Authorization hash',
                type: 'string',
              },
            },
            required: [
              'hash',
            ],
            type: 'object',
          },
          CategoryV3Item: {
            properties: {
              category_code: {
                type: 'string',
              },
              category_name: {
                type: 'string',
              },
              subcategory: {
                items: {},
                type: 'array',
              },
            },
            type: 'object',
          },
          CollectionWebFontTaskArguments: {
            properties: {
              arguments: {
                properties: {
                  collection: {
                    description: 'collection identifier',
                    type: 'string',
                  },
                  css_prefix: {
                    description: 'prefix for CSS rules, used to generate LESS/SCSS',
                    type: 'string',
                  },
                  css_rules_case: {
                    description: 'glyph names conversion rule',
                    enum: [
                      'lowercase',
                      'as_is',
                    ],
                    type: 'string',
                  },
                  css_selector: {
                    description: 'template for glyph selector; placeholder {{glyph}} will be replaced with glyph names',
                    type: 'string',
                  },
                  font_name: {
                    description: 'name of iconic webfont',
                    type: 'string',
                  },
                },
                required: [
                  'collection',
                  'font_name',
                ],
                type: 'object',
              },
            },
            type: 'object',
          },
          CompactCategoryV3Item: {
            properties: {
              api_code: {
                type: 'string',
              },
              name: {
                type: 'string',
              },
            },
            required: [
              'name',
              'api_code',
            ],
            type: 'object',
          },
          CompactIconV3Item: {
            properties: {
              category: {
                type: 'string',
              },
              common_icon_id: {
                description: 'identifier for group of the same icons in different styles; i.e. id of all "home" icons',
                type: 'number',
              },
              created: {
                description: 'date (ISO8601 format) of icon was published',
                type: 'string',
              },
              features: {
                description: 'internal service attribute; internal information about icon features; private; depend on the rights of the current user',
                properties: {
                  bitmap: {
                    description: '"Could user use images in bitmap / raster formats in any size ?"',
                    type: 'number',
                  },
                  nolink: {
                    description: '"Could user use images without any link to Icons8 ?"',
                    type: 'number',
                  },
                  vector: {
                    description: '"Could user use images in vector formats ?"',
                    type: 'number',
                  },
                },
                required: [
                  'bitmap',
                  'vector',
                  'nolink',
                ],
                type: 'object',
              },
              id: {
                description: 'unique icon identifier',
                type: 'number',
              },
              name: {
                description: 'icon name',
                type: 'string',
              },
              platform_code: {
                description: 'icon style',
                type: 'string',
              },
              share: {
                description: 'internal service attribute; some links to spread the world',
                properties: {
                  png: {
                    description: 'some raster images for share the icon',
                    items: {},
                    type: 'array',
                  },
                  url: {
                    description: 'short URL to use in twitter',
                    type: 'string',
                  },
                },
                type: 'object',
              },
              subcategory: {
                properties: {
                  api_code: {
                    type: 'string',
                  },
                  name: {
                    type: 'string',
                  },
                },
                required: [
                  'name',
                  'api_code',
                ],
                type: 'object',
              },
              svg: {
                description: 'plain SVG content of icon',
                type: 'string',
              },
              url: {
                description: 'internal service attribute; the meaning of this attribute is "Identifier of thread at Disquss"',
                type: 'string',
              },
              vector: {
                description: 'URLs to icon sources in different vector formats; private; depend on the current user and could be opened in user\'s browser only',
                properties: {
                  eps: {
                    description: 'absolute URL to file in EPS format',
                    type: 'string',
                  },
                  pdf: {
                    description: 'absolute URL to file in PDF format',
                    type: 'string',
                  },
                  'svg-editable': {
                    description: 'absolute URL to original SVG file',
                    type: 'string',
                  },
                  'svg-simplified': {
                    description: 'absolute URL to compressed and simplified SVG file',
                    type: 'string',
                  },
                },
                type: 'object',
              },
            },
            required: [
              'id',
              'name',
              'platform_code',
              'created',
              'common_icon_id',
              'svg',
              'features',
            ],
            type: 'object',
          },
          IconV3Item: {
            allOf: [
              {
                $ref: '#/components/schemas/CompactIconV3Item',
              },
              {
                properties: {
                  category: {
                    type: 'string',
                  },
                  common_icon_id: {
                    description: 'identifier for group of the same icons in different styles; i.e. id of all "home" icons',
                    type: 'number',
                  },
                  created: {
                    description: 'date (ISO8601 format) of icon was published',
                    type: 'string',
                  },
                  features: {
                    description: 'internal service attribute; internal information about icon features; private; depend on the rights of the current user',
                    properties: {
                      bitmap: {
                        description: '"Could user use images in bitmap / raster formats in any size ?"',
                        type: 'number',
                      },
                      nolink: {
                        description: '"Could user use images without any link to Icons8 ?"',
                        type: 'number',
                      },
                      vector: {
                        description: '"Could user use images in vector formats ?"',
                        type: 'number',
                      },
                    },
                    required: [
                      'bitmap',
                      'vector',
                      'nolink',
                    ],
                    type: 'object',
                  },
                  id: {
                    description: 'unique icon identifier',
                    type: 'number',
                  },
                  name: {
                    description: 'icon name',
                    type: 'string',
                  },
                  platform_code: {
                    description: 'icon style',
                    type: 'string',
                  },
                  share: {
                    description: 'internal service attribute; some links to spread the world',
                    properties: {
                      png: {
                        description: 'some raster images for share the icon',
                        items: {},
                        type: 'array',
                      },
                      url: {
                        description: 'short URL to use in twitter',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                  subcategory: {
                    properties: {
                      api_code: {
                        type: 'string',
                      },
                      name: {
                        type: 'string',
                      },
                    },
                    required: [
                      'name',
                      'api_code',
                    ],
                    type: 'object',
                  },
                  svg: {
                    description: 'plain SVG content of icon',
                    type: 'string',
                  },
                  url: {
                    description: 'internal service attribute; the meaning of this attribute is "Identifier of thread at Disquss"',
                    type: 'string',
                  },
                  vector: {
                    description: 'URLs to icon sources in different vector formats; private; depend on the current user and could be opened in user\'s browser only',
                    properties: {
                      eps: {
                        description: 'absolute URL to file in EPS format',
                        type: 'string',
                      },
                      pdf: {
                        description: 'absolute URL to file in PDF format',
                        type: 'string',
                      },
                      'svg-editable': {
                        description: 'absolute URL to original SVG file',
                        type: 'string',
                      },
                      'svg-simplified': {
                        description: 'absolute URL to compressed and simplified SVG file',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                },
                required: [
                  'id',
                  'name',
                  'platform_code',
                  'created',
                  'common_icon_id',
                  'svg',
                  'features',
                ],
                type: 'object',
              },
            ],
          },
          Meta: {},
          Search: {},
          TaskError: {
            properties: {
              code: {
                description: 'error code',
                enum: [
                  'json_not_valid',
                  'auth_required',
                  'auth_failed',
                  'access_denied',
                  'io_fail',
                  'database_fail',
                  'argument_is_missed',
                  'argument_is_wrong',
                  'paid_feature',
                  'not_possible',
                ],
                type: 'string',
              },
              description: {
                description: 'human readable error message',
                type: 'string',
              },
            },
            required: [
              'code',
              'description',
            ],
            type: 'object',
          },
          TaskResult: {
            properties: {
              description: {
                description: 'human readable description',
                type: 'string',
              },
              id: {
                description: 'task identifier',
                type: 'string',
              },
              results: {
                properties: {
                  zip: {
                    description: 'URL to webfont files in ZIP format',
                    type: 'string',
                  },
                },
                type: 'object',
              },
              status: {
                description: 'task status',
                enum: [
                  '`preparing+',
                  'idle',
                  'in_progress',
                  'timeout',
                  'complete',
                  'failed',
                ],
                type: 'string',
              },
              type: {
                description: 'task type',
                enum: [
                  'create_web_font',
                  'create_svg_set',
                ],
                type: 'string',
              },
            },
            required: [
              'id',
              'type',
              'status',
            ],
            type: 'object',
          },
          TotalV3Item: {
            properties: {
              api_code: {
                description: 'icons style code; in other places it named `plarform` or `platform_api_code`',
                enum: [
                  'ios7',
                  'win8',
                  'win10',
                  'android',
                  'androidL',
                  'color',
                  'office',
                ],
                type: 'string',
              },
              name: {
                type: 'string',
              },
              total: {
                type: 'number',
              },
            },
            required: [
              'name',
              'api_code',
              'total',
            ],
            type: 'object',
          },
          Web_Fonts: {},
        },
      },
      info: {
        description: `# Icons8 API␊
        ␊
        Icons8 API allows us to search and obtain [our icons](https://icons8.com/web-app).␊
        ␊
        You're welcome to use our icons to extend the functionality of your web and mobile applications, website templates, and even tattoos.␊
        ␊
        ![Tattoos](https://cdn.rawgit.com/icons8/api-docs/cff6fdf0/tattoos.svg)␊
        ␊
        ## Usage Examples␊
        ␊
        Some examples of what you can do with our icons:␊
        ␊
        * **Template customization.** This way, [Canva](https://www.canva.com/) uses our icons to customize their layouts.␊
        ␊
        * **Graphics and text editors.** [Gravit](https://gravit.io/) allows to insert our icons into the mockups.␊
        ␊
        * **Any application with customization.** [TimeTune](http://timetune.center/) uses our icons to customize the activities.␊
        ␊
        ## Getting Started␊
        ␊
        To get started, please [contact us](https://icons8.com/contact) to obtain an API key.␊
        ␊
        ## Pricing␊
        ␊
        Our API license starts at $100/month.`,
        title: 'Use a [New Version](https://icons8.github.io/icons8-docs/) Instead',
        version: '1.0.0',
        'x-apisguru-categories': [
          'media',
        ],
        'x-logo': {
          url: 'https://twitter.com/icons_8/profile_image?size=original',
        },
        'x-origin': [
          {
            converter: {
              url: 'https://github.com/lucybot/api-spec-converter',
              version: '2.7.31',
            },
            format: 'apiBlueprint',
            url: 'https://raw.githubusercontent.com/icons8/api-docs/master/apiary.apib',
            version: '1A',
          },
        ],
        'x-providerName': 'icons8.com',
      },
      openapi: '3.0.0',
      paths: {
        '/api/iconsets/v3/categories?platform={platform}&language={language}': {
          get: {
            description: `The operation will not return the categories that have less than 10 icons.␊
            We need it to test the categories without showing garbage on the production website.`,
            parameters: [
              {
                description: 'the platform that we are searching icons for',
                in: 'path',
                name: 'platform',
                required: true,
                schema: {
                  enum: [
                    'ios7',
                    'win8',
                    'win10',
                    'android',
                    'androidL',
                    'color',
                    'office',
                  ],
                  type: 'string',
                },
              },
              {
                description: 'the language code to get localized result',
                example: 'en-US',
                in: 'path',
                name: 'language',
                required: true,
                schema: {
                  enum: [
                    'en-US',
                    'fr-FR',
                    'de-DE',
                    'it-IT',
                    'pt-BR',
                    'pl-PL',
                    'ru-RU',
                    'es-ES',
                  ],
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          parameters: {
                            language: '',
                            platform: '',
                          },
                          result: {
                            categories: [
                              {
                                category_code: '',
                                category_name: '',
                                subcategory: [
                                  {
                                    icons: [
                                      {
                                        common_icon_id: 0,
                                        created: '',
                                        features: {
                                          bitmap: 0,
                                          nolink: 0,
                                          vector: 0,
                                        },
                                        id: 0,
                                        name: '',
                                        platform_code: '',
                                        svg: '',
                                        url: '',
                                      },
                                    ],
                                    subcategory_code: '',
                                    subcategory_name: '',
                                  },
                                ],
                              },
                              {
                                api_code: 'Alphabet',
                                category_code: '',
                                category_name: '',
                                name: 'Alphabet',
                                subcategory: [
                                  {
                                    icons: [
                                      {
                                        common_icon_id: 0,
                                        created: '',
                                        features: {
                                          bitmap: 0,
                                          nolink: 0,
                                          vector: 0,
                                        },
                                        id: 0,
                                        name: '',
                                        platform_code: '',
                                        svg: '',
                                        url: '',
                                      },
                                    ],
                                    subcategory_code: '',
                                    subcategory_name: '',
                                  },
                                ],
                              },
                              {
                                api_code: 'Very_Basic',
                                category_code: '',
                                category_name: '',
                                name: 'Very Basic',
                                subcategory: [
                                  {
                                    icons: [
                                      {
                                        common_icon_id: 0,
                                        created: '',
                                        features: {
                                          bitmap: 0,
                                          nolink: 0,
                                          vector: 0,
                                        },
                                        id: 0,
                                        name: '',
                                        platform_code: '',
                                        svg: '',
                                        url: '',
                                      },
                                    ],
                                    subcategory_code: '',
                                    subcategory_name: '',
                                  },
                                ],
                              },
                              {
                                api_code: 'Photo_Video',
                                category_code: '',
                                category_name: '',
                                name: 'Photo and Video',
                                subcategory: [
                                  {
                                    icons: [
                                      {
                                        common_icon_id: 0,
                                        created: '',
                                        features: {
                                          bitmap: 0,
                                          nolink: 0,
                                          vector: 0,
                                        },
                                        id: 0,
                                        name: '',
                                        platform_code: '',
                                        svg: '',
                                        url: '',
                                      },
                                    ],
                                    subcategory_code: '',
                                    subcategory_name: '',
                                  },
                                ],
                              },
                            ],
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        parameters: {
                          description: 'copy of the input parameters from the request',
                          properties: {
                            language: {
                              type: 'string',
                            },
                            platform: {
                              type: 'string',
                            },
                          },
                          type: 'object',
                        },
                        result: {
                          description: 'the result of operation',
                          properties: {
                            categories: {
                              items: {},
                              type: 'array',
                            },
                          },
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'Categories',
            tags: [],
          },
        },
        '/api/iconsets/v3/category?category={category}&subcategory={subcategory}&amount={amount}&offset={offset}&platform={platform}&language={language}': {
          get: {
            description: '',
            parameters: [
              {
                description: 'the code of category',
                example: 'free_icons',
                in: 'path',
                name: 'category',
                required: true,
                schema: {
                  type: 'string',
                },
              },
              {
                description: 'the code of subcategory',
                example: 'home_appliances',
                in: 'path',
                name: 'subcategory',
                required: true,
                schema: {
                  type: 'string',
                },
              },
              {
                description: 'the maximum number of icons which you\'d like to receive',
                in: 'path',
                name: 'amount',
                required: true,
                schema: {
                  default: 25,
                  type: 'number',
                },
              },
              {
                description: 'the offset from the first received result',
                in: 'path',
                name: 'offset',
                required: true,
                schema: {
                  type: 'number',
                },
              },
              {
                description: 'the style of the icons',
                in: 'path',
                name: 'platform',
                required: true,
                schema: {
                  enum: [
                    'ios7',
                    'win8',
                    'win10',
                    'android',
                    'androidL',
                    'color',
                    'office',
                  ],
                  type: 'string',
                },
              },
              {
                description: 'the language code to get localized result',
                example: 'en-US',
                in: 'path',
                name: 'language',
                required: true,
                schema: {
                  enum: [
                    'en-US',
                    'fr-FR',
                    'de-DE',
                    'it-IT',
                    'pt-BR',
                    'pl-PL',
                    'ru-RU',
                    'es-ES',
                  ],
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          parameters: {
                            amount: 0,
                            category: '',
                            language: '',
                            offset: '',
                            platform: '',
                            subcategory: '',
                          },
                          result: {
                            category: [
                              {
                                category_code: '',
                                category_name: '',
                                subcategory: [
                                  {
                                    icons: [
                                      {
                                        common_icon_id: 0,
                                        created: '',
                                        features: {
                                          bitmap: 0,
                                          nolink: 0,
                                          vector: 0,
                                        },
                                        id: 0,
                                        name: '',
                                        platform_code: '',
                                        svg: '',
                                        url: '',
                                      },
                                    ],
                                    subcategory_code: '',
                                    subcategory_name: '',
                                  },
                                ],
                              },
                              {
                                category: 'Very Basic',
                                common_icon_id: '72',
                                created: '2015-05-21T05:28:59+00:00',
                                features: {
                                  bitmap: '1',
                                  nolink: '1',
                                  vector: '1',
                                },
                                id: '12229',
                                name: 'Home',
                                platform_code: 'color',
                                share: {
                                  png: [
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/google/h/home.png',
                                    },
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/twitter/h/home.png',
                                      type: 'twitter',
                                    },
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/social/h/home.png',
                                      type: 'social',
                                    },
                                  ],
                                  url: 'http://ic8.link/12229',
                                },
                                subcategory: {
                                  api_code: 'website_sections',
                                  name: 'Website Sections',
                                },
                                svg: '/* Plain SVG content here */',
                                url: '/web-app/12229/home',
                                vector: {
                                  eps: 'absolute/private/url/to/home.eps',
                                  pdf: 'absolute/private/url/to/home.pdf',
                                  'svg-editable': 'absolute/private/url/to/original/home.svg',
                                  'svg-simplified': 'absolute/private/url/to/simplified/home.svg',
                                },
                              },
                            ],
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        parameters: {
                          description: 'copy of the input parameters from the request',
                          properties: {
                            amount: {
                              type: 'number',
                            },
                            category: {
                              type: 'string',
                            },
                            language: {
                              type: 'string',
                            },
                            offset: {
                              type: 'string',
                            },
                            platform: {
                              type: 'string',
                            },
                            subcategory: {
                              type: 'string',
                            },
                          },
                          type: 'object',
                        },
                        result: {
                          description: 'the result of operation',
                          properties: {
                            category: {
                              items: {},
                              type: 'array',
                            },
                          },
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'By Category',
            tags: [],
          },
        },
        '/api/iconsets/v3/latest?term={term}&amount={amount}&offset={offset}&platform={platform}&language={language}': {
          get: {
            description: '',
            parameters: [
              {
                description: 'the maximum number of icons which you\'d like to receive',
                in: 'path',
                name: 'amount',
                required: true,
                schema: {
                  default: 25,
                  type: 'number',
                },
              },
              {
                description: 'the offset from the first received result',
                in: 'path',
                name: 'offset',
                required: true,
                schema: {
                  type: 'number',
                },
              },
              {
                description: 'the style of the icons',
                in: 'path',
                name: 'platform',
                required: true,
                schema: {
                  enum: [
                    'ios7',
                    'win8',
                    'win10',
                    'android',
                    'androidL',
                    'color',
                    'office',
                  ],
                  type: 'string',
                },
              },
              {
                description: 'the language code to get localized result',
                example: 'en-US',
                in: 'path',
                name: 'language',
                required: true,
                schema: {
                  enum: [
                    'en-US',
                    'fr-FR',
                    'de-DE',
                    'it-IT',
                    'pt-BR',
                    'pl-PL',
                    'ru-RU',
                    'es-ES',
                  ],
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          parameters: {
                            amount: 0,
                            language: '',
                            offset: '',
                            platform: '',
                            term: '',
                          },
                          result: {
                            latest: [
                              {
                                common_icon_id: 0,
                                created: 'color',
                                features: {
                                  bitmap: 0,
                                  nolink: 0,
                                  vector: 0,
                                },
                                id: 0,
                                name: '',
                                platform_code: '',
                                share: {
                                  png: [
                                    {
                                      link: '',
                                    },
                                  ],
                                  url: '',
                                },
                                subcategory: {
                                  api_code: '',
                                  name: '',
                                },
                                svg: '',
                                vector: {
                                  eps: '',
                                  pdf: '',
                                  'svg-simplified': '',
                                },
                              },
                              {
                                common_icon_id: '72',
                                created: '2015-05-21T05:28:59+00:00',
                                features: {
                                  bitmap: '1',
                                  nolink: '1',
                                  vector: '1',
                                },
                                id: '12229',
                                name: 'Home',
                                platform_code: 'color',
                                share: {
                                  png: [
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/google/h/home.png',
                                    },
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/twitter/h/home.png',
                                      type: 'twitter',
                                    },
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/social/h/home.png',
                                      type: 'social',
                                    },
                                  ],
                                  url: 'http://ic8.link/12229',
                                },
                                subcategory: {
                                  api_code: '',
                                  name: '',
                                },
                                svg: '',
                                url: '/web-app/12229/home',
                                vector: {
                                  eps: '',
                                  pdf: '',
                                  'svg-simplified': '',
                                },
                              },
                            ],
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        parameters: {
                          description: 'copy of the input parameters from the request',
                          properties: {
                            amount: {
                              type: 'number',
                            },
                            language: {
                              type: 'string',
                            },
                            offset: {
                              type: 'string',
                            },
                            platform: {
                              type: 'string',
                            },
                            term: {
                              type: 'string',
                            },
                          },
                          type: 'object',
                        },
                        result: {
                          description: 'the result of operation',
                          properties: {
                            latest: {
                              items: {},
                              type: 'array',
                            },
                          },
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'Latest',
            tags: [],
          },
        },
        '/api/iconsets/v3/search?term={term}&amount={amount}&offset={offset}&platform={platform}&language={language}&exact_amount={exact_amount}': {
          get: {
            description: '',
            parameters: [
              {
                description: `the name or tag of the icon or any other phrase.␊
                e.g. use "@home" to find icons with the tag "home" and "=home" to find icons with the name "home"␊
                `,
                example: 'home',
                in: 'path',
                name: 'term',
                required: true,
                schema: {
                  type: 'string',
                },
              },
              {
                description: 'the maximum number of icons which you\'d like to receive (will be multiplied by platforms count, if you didn\'t specify the platform and didn\'t set the \'exact_amount\' parameter)',
                in: 'path',
                name: 'amount',
                required: true,
                schema: {
                  default: 25,
                  type: 'number',
                },
              },
              {
                description: 'set it to \'true\' if you\'d like to receive the exact amount of icons, not multiplied by platforms count',
                in: 'path',
                name: 'exact_amount',
                required: true,
                schema: {
                  type: 'boolean',
                },
              },
              {
                description: 'the offset from the first received result',
                in: 'path',
                name: 'offset',
                required: true,
                schema: {
                  type: 'number',
                },
              },
              {
                description: 'the style of the icons',
                in: 'path',
                name: 'platform',
                required: true,
                schema: {
                  enum: [
                    'ios7',
                    'win8',
                    'win10',
                    'android',
                    'androidL',
                    'color',
                    'office',
                  ],
                  type: 'string',
                },
              },
              {
                description: 'the language code to get localized result',
                example: 'en-US',
                in: 'path',
                name: 'language',
                required: true,
                schema: {
                  enum: [
                    'en-US',
                    'fr-FR',
                    'de-DE',
                    'it-IT',
                    'pt-BR',
                    'pl-PL',
                    'ru-RU',
                    'es-ES',
                  ],
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          parameters: {
                            amount: 0,
                            language: '',
                            offset: '',
                            platform: '',
                            term: '',
                          },
                          result: {
                            search: [
                              {
                                common_icon_id: 0,
                                created: 'color',
                                features: {
                                  bitmap: 0,
                                  nolink: 0,
                                  vector: 0,
                                },
                                id: 0,
                                name: '',
                                platform_code: '',
                                share: {
                                  png: [
                                    {
                                      link: '',
                                    },
                                  ],
                                  url: '',
                                },
                                subcategory: {
                                  api_code: '',
                                  name: '',
                                },
                                svg: '',
                                vector: {
                                  eps: '',
                                  pdf: '',
                                  'svg-simplified': '',
                                },
                              },
                              {
                                category: 'Very Basic',
                                common_icon_id: '72',
                                created: '2015-05-21T05:28:59+00:00',
                                features: {
                                  bitmap: '1',
                                  nolink: '1',
                                  vector: '1',
                                },
                                id: '12229',
                                name: 'Home',
                                platform_code: 'color',
                                share: {
                                  png: [
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/google/h/home.png',
                                    },
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/twitter/h/home.png',
                                      type: 'twitter',
                                    },
                                    {
                                      link: 'https://maxcdn.icons8.com/Share/social/h/home.png',
                                      type: 'social',
                                    },
                                  ],
                                  url: 'http://ic8.link/12229',
                                },
                                subcategory: {
                                  api_code: 'website_sections',
                                  name: 'Website Sections',
                                },
                                svg: '/* Plain SVG content here */',
                                url: '/web-app/12229/home',
                                vector: {
                                  eps: 'absolute/private/url/to/home.eps',
                                  pdf: 'absolute/private/url/to/home.pdf',
                                  'svg-editable': 'absolute/private/url/to/original/home.svg',
                                  'svg-simplified': 'absolute/private/url/to/simplified/home.svg',
                                },
                              },
                            ],
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        parameters: {
                          description: 'copy of the input parameters from the request',
                          properties: {
                            amount: {
                              type: 'number',
                            },
                            language: {
                              type: 'string',
                            },
                            offset: {
                              type: 'string',
                            },
                            platform: {
                              type: 'string',
                            },
                            term: {
                              type: 'string',
                            },
                          },
                          type: 'object',
                        },
                        result: {
                          description: 'the result of operation',
                          properties: {
                            search: {
                              items: {},
                              type: 'array',
                            },
                          },
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'By Keyword v3',
            tags: [],
          },
        },
        '/api/iconsets/v3/total?since={since}': {
          get: {
            description: '',
            parameters: [
              {
                description: `the optional date to calculate the total number of icons that were created after it.␊
                It should be in format "four year digits - dash - two month number digits - dash - two day number digits. For example 2014-12-31 means "31th of December, 2014".␊
                `,
                example: '2014-12-31',
                in: 'path',
                name: 'since',
                required: true,
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          parameters: {
                            since: '',
                          },
                          result: {
                            total: [
                              {
                                api_code: 'ios7',
                                name: '',
                                total: 0,
                              },
                              {
                                api_code: 'win8',
                                name: 'Windows 8/Metro',
                                total: '802',
                              },
                              {
                                api_code: 'ios7',
                                name: 'iPhone/iOS 7',
                                total: '7379',
                              },
                            ],
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        parameters: {
                          description: 'copy of the input parameters from the request',
                          properties: {
                            since: {
                              type: 'string',
                            },
                          },
                          type: 'object',
                        },
                        result: {
                          description: 'the result of operation',
                          properties: {
                            total: {
                              items: {},
                              type: 'array',
                            },
                          },
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'Totals',
            tags: [],
          },
        },
        '/api/iconsets/v4/search?term={term}&amount={amount}&offset={offset}&platform={platform}&language={language}&exact_amount={exact_amount}': {
          get: {
            description: '',
            parameters: [
              {
                description: `the name or tag of the icon or any other phrase.␊
                e.g. use "@home" to find icons with the tag "home" and "=home" to find icons with the name "home"␊
                `,
                example: 'home',
                in: 'path',
                name: 'term',
                required: true,
                schema: {
                  type: 'string',
                },
              },
              {
                description: 'the maximum number of icons which you\'d like to receive (will be multiplied by platforms count, if you didn\'t specify the platform and didn\'t set the \'exact_amount\' parameter)',
                in: 'path',
                name: 'amount',
                required: true,
                schema: {
                  default: 50,
                  type: 'number',
                },
              },
              {
                description: 'the offset from the first received result',
                in: 'path',
                name: 'offset',
                required: true,
                schema: {
                  type: 'number',
                },
              },
              {
                description: 'the style of the icons',
                in: 'path',
                name: 'platform',
                required: true,
                schema: {
                  default: 'all',
                  enum: [
                    'all',
                    'ios7',
                    'ios11',
                    'win8',
                    'win10',
                    'android',
                    'androidL',
                    'color',
                    'office',
                    'ultraviolet',
                    'nolan',
                    'p1em',
                    'dotty',
                    'dusk',
                    'Dusk_Wired',
                    'cotton',
                    'doodle',
                    'flat_round',
                  ],
                  type: 'string',
                },
              },
              {
                description: 'the language code to get localized result',
                in: 'path',
                name: 'language',
                required: true,
                schema: {
                  default: 'en-US',
                  enum: [
                    'en-US',
                    'fr-FR',
                    'de-DE',
                    'it-IT',
                    'pt-BR',
                    'pl-PL',
                    'ru-RU',
                    'es-ES',
                    'zh-CN',
                    'ja-JP',
                  ],
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          icons: [
                            {
                              category: 'Travel',
                              commonId: '3022',
                              commonName: 'sea-waves',
                              id: '23756',
                              name: 'Sea Waves',
                              platform: 'win10',
                              timestamp: '1461024690',
                            },
                            {
                              category: 'Animals',
                              commonId: '3035',
                              commonName: 'starfish',
                              id: '19995',
                              name: 'Sea Star',
                              platform: 'win10',
                              timestamp: '1450119085',
                            },
                          ],
                          parameters: {
                            'amount `50`': '',
                            language: 'en-US',
                            offset: '0',
                            platform: 'win10',
                            term: 'sea',
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        icons: {
                          description: 'the result of operation',
                          items: {},
                          type: 'array',
                        },
                        parameters: {
                          description: 'copy of the input parameters from the request',
                          properties: {
                            'amount `50`': {
                              type: 'string',
                            },
                            language: {
                              type: 'string',
                            },
                            offset: {
                              type: 'string',
                            },
                            platform: {
                              type: 'string',
                            },
                            term: {
                              type: 'string',
                            },
                          },
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'By Keyword v4',
            tags: [],
          },
        },
        '/api/task/web-font/collection': {
          post: {
            description: '',
            requestBody: {
              $ref: '#/components/requestBodies/Body',
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          messages: [
                            {
                              code: 'paid_feature',
                              description: 'Icons "dog", "cat" and 5 more were excluded',
                            },
                            {
                              code: 'not_possible',
                              description: 'Icons "dog-color" and "cat-color" were excluded',
                            },
                          ],
                          result: {
                            description: '',
                            id: 'abc-def',
                            results: {
                              zip: 'https://st.icons8.com/zip/abc-def/icons8-font.zip',
                            },
                            status: 'complete',
                            type: 'create_web_font',
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        messages: {
                          items: {},
                          type: 'array',
                        },
                        result: {
                          properties: {
                            description: {
                              description: 'human readable description',
                              type: 'string',
                            },
                            id: {
                              description: 'task identifier',
                              type: 'string',
                            },
                            results: {
                              properties: {
                                zip: {
                                  type: 'string',
                                },
                              },
                              type: 'object',
                            },
                            status: {
                              description: 'task status',
                              type: 'string',
                            },
                            type: {
                              description: 'task type',
                              type: 'string',
                            },
                          },
                          required: [
                            'id',
                            'type',
                            'status',
                          ],
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'From a Collection',
            tags: [],
          },
        },
        '/api/task/web-font/icons': {
          post: {
            description: '',
            requestBody: {
              $ref: '#/components/requestBodies/Body',
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      response: {
                        value: {
                          messages: [
                            {
                              code: 'paid_feature',
                              description: 'Icons "dog", "cat" and 5 more were excluded',
                            },
                            {
                              code: 'not_possible',
                              description: 'Icons "dog-color" and "cat-color" were excluded',
                            },
                          ],
                          result: {
                            description: '',
                            id: 'abc-def',
                            results: {
                              zip: 'https://st.icons8.com/zip/abc-def/icons8-font.zip',
                            },
                            status: 'complete',
                            type: 'create_web_font',
                          },
                        },
                      },
                    },
                    schema: {
                      properties: {
                        messages: {
                          items: {},
                          type: 'array',
                        },
                        result: {
                          properties: {
                            description: {
                              description: 'human readable description',
                              type: 'string',
                            },
                            id: {
                              description: 'task identifier',
                              type: 'string',
                            },
                            results: {
                              properties: {
                                zip: {
                                  type: 'string',
                                },
                              },
                              type: 'object',
                            },
                            status: {
                              description: 'task status',
                              type: 'string',
                            },
                            type: {
                              description: 'task type',
                              type: 'string',
                            },
                          },
                          required: [
                            'id',
                            'type',
                            'status',
                          ],
                          type: 'object',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'OK',
                headers: {},
              },
            },
            summary: 'From Separate Icons',
            tags: [],
          },
        },
      },
      servers: [
        {
          url: 'https://api.icons8.com/',
        },
      ],
      tags: [
        {
          description: `## Platform␊
          ␊
          Attributes and parameters named `platform` or `platform_api_code` or `platform_code` all indicate the style of the icons.␊
          We’re sorry we have various parameters meaning the same.␊
          ␊
          `platform` | Icon style | Example␊
          ---:|---|---␊
          win8 | icons in the Microsoft Windows 8/Metro style | [example](https://icons8.com/windows-8-icons/)␊
          win10 | icons in the Microsoft Windows 10/Threshold style | [example](https://icons8.com/download-huge-windows8-set/)␊
          ios7 | icons in the Apple iOS 7/8/9/10 style | [example](https://icons8.com/free-ios-7-icons-in-vector/)␊
          android | icons in the Google Android 4 Kitkat style | [example](https://icons8.com/android-kitkat-icons/)␊
          androidL | icons in the Google Android 5 Lollipop (Material) style | [example](https://icons8.com/android-icons/)␊
          color | flat color icons | [example](https://icons8.com/color-icons/)␊
          office | icons in the Microsoft Office style | [example](https://icons8.com/office-icons/)␊
          ␊
          ␊
          Icon names, categories and tags are localized. Here's the list of supported languages:␊
          ␊
          `language` | Language name␊
          ---|---␊
          `en-US` | English␊
          `fr-FR` | French␊
          `de-DE` | German␊
          `it-IT` | Italian␊
          `pt-BR` | Portuguese␊
          `pl-PL` | Polish␊
          `ru-RU` | Russian␊
          `es-ES` | Spanish␊
          `zh-CN` | Chinese␊
          `ja-JP` | Japanese␊
          ␊
          The primary language is English - if we do not translate something, it will be in English.`,
          name: 'Parameters',
        },
      ],
    }

## parseOpenAPI success param-in-path

> Snapshot 1

    {
      info: {
        title: 'Fast API',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/': {
          get: {
            operationId: 'read_root__get',
            parameters: [
              {
                in: 'path',
                name: 'q',
                required: false,
                schema: {
                  title: 'Q',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
            },
            summary: 'Read Root',
          },
        },
      },
    }

## parseOpenAPI success pdfbroker

> Snapshot 1

    {
      components: {
        schemas: {
          ColorDto: {
            additionalProperties: false,
            description: 'Set color',
            properties: {
              b: {
                description: 'Get or sets B value of RGB color',
                format: 'int32',
                maximum: 255,
                minimum: 0,
                readOnly: true,
                type: 'integer',
              },
              g: {
                description: 'Get or sets G value of RGB color',
                format: 'int32',
                maximum: 255,
                minimum: 0,
                readOnly: true,
                type: 'integer',
              },
              r: {
                description: 'Get or sets R value of RGB color',
                format: 'int32',
                maximum: 255,
                minimum: 0,
                readOnly: true,
                type: 'integer',
              },
            },
            type: 'object',
          },
          FoRequestDto: {
            additionalProperties: false,
            description: 'The basic request with the XSL-FO document as a Base64 encoded string with a set of resources provided with a name and the data of the resource as a Base64 encoded string.',
            properties: {
              foDocumentBase64String: {
                description: 'This is the complete XSL-FO document provided using Base64 encoding.',
                type: 'string',
              },
              resources: {
                additionalProperties: {
                  type: 'string',
                },
                description: 'This is a set of key-value pairs of digital resources like images that is referenced in the XSL-FO document. It uses the filename as key and the data is provided as a Base64 encoded string.',
                type: 'object',
              },
            },
            type: 'object',
          },
          FoTransformRequestDto: {
            additionalProperties: false,
            description: 'The XSL-FO transform document and xml data document as a Base64 encoded string with a set of resources provided with a name and the data of the resource as a Base64 encoded string.',
            properties: {
              foDocumentBase64String: {
                description: 'This is the complete XSL-FO document provided using Base64 encoding.',
                type: 'string',
              },
              resources: {
                additionalProperties: {
                  type: 'string',
                },
                description: 'This is a set of key-value pairs of digital resources like images that is referenced in the XSL-FO document. It uses the filename as key and the data is provided as a Base64 encoded string.',
                type: 'object',
              },
              xmlDataDocumentBase64String: {
                description: 'This is xml data document on which the XSL-FO transform document is applied. Provided using Base64 encoding.',
                type: 'string',
              },
            },
            type: 'object',
          },
          FontDto: {
            additionalProperties: false,
            description: 'The Font dto object',
            properties: {
              name: {
                description: 'Gets the name of the font',
                readOnly: true,
                type: 'string',
              },
              size: {
                description: 'Gets the size of the font',
                format: 'float',
                readOnly: true,
                type: 'number',
              },
              style: {
                description: 'Gets the style of the font',
                enum: [
                  'Regular',
                  'Bold',
                  'Italic',
                  'BoldItalic',
                ],
                readOnly: true,
                type: 'string',
              },
            },
            type: 'object',
          },
          ImageResponseDto: {
            additionalProperties: false,
            description: 'When setting the Accept-header in the request to "application/json" the image file will be return as Base64 encoded string. Note that converting data to Base64 encoded strings increases the response size with approximately 33%, if you can accept the a binary format it\'s better to use Accept-header "image/jpeg", "image/png" or "image/gif".',
            properties: {
              errorMessage: {
                description: 'If any error occurs the message will be displayed in here',
                type: 'string',
              },
              imageBase64String: {
                description: 'The Base64 encoded string that is the image file.',
                type: 'string',
              },
            },
            type: 'object',
          },
          PdfConcatenationRequestDto: {
            additionalProperties: false,
            description: 'Request to concatenate a list of Pdf documents to a single Pdf document.',
            properties: {
              pdfDocumentsAsBase64String: {
                description: 'The list of Pdf documents encoded as Base64 strings.',
                items: {
                  type: 'string',
                },
                type: 'array',
              },
            },
            type: 'object',
          },
          PdfResponseDto: {
            additionalProperties: false,
            description: 'When setting the Accept-header in the request to "application/json" the content of the pdf file will be return as Base64 encoded string. Note that converting data to Base64 encoded strings increases the response size with approximately 33%, if you can accept the a binary format it\'s better to use Accept-header "application/pdf".',
            properties: {
              errorMessage: {
                description: 'If any error occurs the message will be displayed in here',
                type: 'string',
              },
              pdfFileBase64String: {
                description: 'The Base64 encoded string that is the pdf file.',
                type: 'string',
              },
            },
            type: 'object',
          },
          PdfToImageOptions: {
            additionalProperties: false,
            properties: {
              height: {
                description: 'Set the height of the output image, default value is width of source document. To scale height, and keeping proportions, do not set width;',
                format: 'int32',
                type: 'integer',
              },
              horizontalResolution: {
                description: 'Set the horizontal resolution, default is 96 dpi;',
                format: 'double',
                type: 'number',
              },
              imageFormat: {
                description: 'Valid options are "image/jpeg", "image/png" or "image/gif". Default is "image/png"',
                type: 'string',
              },
              jpegQuality: {
                description: 'Sets the quality of jpeg images, range 0 to 100, default is 75',
                format: 'int32',
                type: 'integer',
              },
              pageNumber: {
                description: 'Which page of the pdf file to generate image from, default is first page',
                format: 'int32',
                type: 'integer',
              },
              pngCompressionLevel: {
                description: 'Sets the png compression level, range 1 - 9, default is 6',
                format: 'int32',
                type: 'integer',
              },
              transparent: {
                description: 'Keep the background of the image transparent. This setting is not available in JPEG-files, since transparency is not supported in the JPEG format.',
                type: 'boolean',
              },
              verticalResolution: {
                description: 'Set the vertical resolution, default is 96 dpi;',
                format: 'double',
                type: 'number',
              },
              width: {
                description: 'Set the width of the output image, default value is width of source document. To scale width, and keeping proportions, do not set height;',
                format: 'int32',
                type: 'integer',
              },
            },
            type: 'object',
          },
          PdfToImageRequestDto: {
            additionalProperties: false,
            properties: {
              options: {
                $ref: '#/components/schemas/PdfToImageOptions',
              },
              pdfFileBase64String: {
                description: 'The pdf file to generate image from, as Base64 encoded string.',
                type: 'string',
              },
            },
            type: 'object',
          },
          PdfWriteStringOptions: {
            additionalProperties: false,
            description: 'Options for writing string in pdf page;',
            properties: {
              font: {
                $ref: '#/components/schemas/FontDto',
              },
              pageNumber: {
                description: 'Get or set which page in the pdf to write on, default is first page.',
                format: 'int32',
                type: 'integer',
              },
              text: {
                description: 'The text to write in the pdf',
                type: 'string',
              },
              textColor: {
                $ref: '#/components/schemas/ColorDto',
              },
              xOrigin: {
                description: 'Get or set the point from where the X axis position should be calculated from. Default value is from left side of page.',
                enum: [
                  'Left',
                  'Center',
                  'Right',
                ],
                type: 'string',
              },
              xPosition: {
                description: 'Get or set the X axis position on where to write string, in reference to XOrigin.',
                format: 'float',
                type: 'number',
              },
              yOrigin: {
                description: 'Get or set the point from where the Y axis position should be calculated from. Default value is from top of page.',
                enum: [
                  'Top',
                  'Center',
                  'Bottom',
                ],
                type: 'string',
              },
              yPosition: {
                description: 'Get or set the Y axis position on where to write string, in reference to YOrigin.',
                format: 'float',
                type: 'number',
              },
            },
            type: 'object',
          },
          PdfWriteStringRequestDto: {
            additionalProperties: false,
            description: 'The request dto object to write a string on pdf page',
            properties: {
              fontFileBase64String: {
                description: 'System fonts are available, but you can provide your own font file to be embedded in the pdf document. Send font as Base64 encoded string.',
                type: 'string',
              },
              options: {
                $ref: '#/components/schemas/PdfWriteStringOptions',
              },
              pdfFileBase64String: {
                description: 'The pdf file to add text to, as Base64 encoded string.',
                type: 'string',
              },
            },
            type: 'object',
          },
          ProblemDetails: {
            additionalProperties: {
              type: 'object',
            },
            properties: {
              detail: {
                type: 'string',
              },
              instance: {
                type: 'string',
              },
              status: {
                format: 'int32',
                nullable: true,
                type: 'integer',
              },
              title: {
                type: 'string',
              },
              type: {
                type: 'string',
              },
            },
            type: 'object',
          },
          WkHtmlToPdfRequestDto: {
            additionalProperties: false,
            description: 'WkHtmlToPdfRequestDto is the data transfer object for generating a pdf using wkhtmltopdf;',
            properties: {
              url: {
                description: 'The url to generate pdf from',
                type: 'string',
              },
              wkHtmlToPdfArguments: {
                additionalProperties: {
                  type: 'string',
                },
                description: 'Command line arguments passed to wkhtmltopdf.',
                type: 'object',
              },
            },
            type: 'object',
          },
        },
        securitySchemes: {
          OAuth2: {
            flows: {
              clientCredentials: {
                scopes: {
                  pdfbroker: 'Scope to access the PdfBroker API.',
                },
                tokenUrl: 'https://login.pdfbroker.io/connect/token',
              },
            },
            type: 'oauth2',
          },
        },
      },
      info: {
        description: 'PdfBroker.io is an api for creating pdf files from Xsl-Fo or Html and other useful pdf utilities.',
        termsOfService: 'https://www.pdfbroker.io/terms',
        title: 'PdfBroker.io API',
        version: 'v1',
      },
      openapi: '3.0.1',
      paths: {
        '/api/pdf': {
          get: {
            responses: {
              200: {
                description: 'Success',
              },
            },
            summary: 'Basic method to verify api is up and running',
            tags: [
              'Pdf',
            ],
          },
        },
        '/api/pdf/pdfconcat': {
          post: {
            requestBody: {
              content: {
                'application/json': {
                  example: `{␍␊
                    "pdfDocumentsAsBase64String": [␍␊
                      "<Encode your pdf documents as Base64 encoded string>",␍␊
                      "<Encode your pdf documents as Base64 encoded string>"␍␊
                    ]␍␊
                  }`,
                  schema: {
                    $ref: '#/components/schemas/PdfConcatenationRequestDto',
                  },
                },
                'multipart/form-data': {
                  encoding: {
                    pdfdocument1: {
                      contentType: 'application/octet-stream',
                    },
                    pdfdocument2: {
                      contentType: 'application/octet-stream',
                    },
                  },
                  schema: {
                    properties: {
                      pdfdocument1: {
                        description: 'Add pdf files to be concatenated into single file',
                        format: 'binary',
                        type: 'string',
                      },
                      pdfdocument2: {
                        description: 'You can add more than two files in the same request',
                        format: 'binary',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                },
              },
              description: 'PdfConcat Request. Add two or more pdf files and concatenate pages into single pdf document.',
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                },
                description: 'Returns the newly created pdf file. Either the file directly or serialized as Json if Accept-header is set to application/json',
              },
              400: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If any error occurs parsing input',
              },
              415: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If content-type of request is not set to multipart/form-data or application/json',
              },
            },
            summary: 'Concatenate multiple pdf files into single pdf file..',
            tags: [
              'Pdf',
            ],
          },
        },
        '/api/pdf/pdftoimage': {
          post: {
            requestBody: {
              content: {
                'application/json': {
                  example: `{␍␊
                    "pdfFileBase64String": "<Encode your existing PDF document as Base64 encoded string>",␍␊
                    "options": {␍␊
                      "pageNumber": 1,␍␊
                      "imageFormat": "image/jpeg",␍␊
                      "horizontalResolution": 96.0,␍␊
                      "verticalResolution": 96.0,␍␊
                      "width": 0,␍␊
                      "height": 0,␍␊
                      "transparent": false,␍␊
                      "jpegQuality": 90,␍␊
                      "pngCompressionLevel": 6␍␊
                    }␍␊
                  }`,
                  schema: {
                    $ref: '#/components/schemas/PdfToImageRequestDto',
                  },
                },
                'multipart/form-data': {
                  encoding: {
                    options: {
                      contentType: 'application/json',
                    },
                    pdfdocument: {
                      contentType: 'application/octet-stream',
                    },
                  },
                  schema: {
                    properties: {
                      options: {
                        description: 'After pdfdocument is added, add an entry named options with your PdfToImageOptions object serialized as JSON.',
                        format: 'string',
                        type: 'string',
                      },
                      pdfdocument: {
                        description: 'An entry named pdfdocument is required in the multipart/form-data request',
                        format: 'binary',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                },
              },
              description: 'PdfToImage Request. Create an image of a page in an existing pdf document.',
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ImageResponseDto',
                    },
                  },
                  'image/gif': {
                    schema: {
                      $ref: '#/components/schemas/ImageResponseDto',
                    },
                  },
                  'image/jpeg': {
                    schema: {
                      $ref: '#/components/schemas/ImageResponseDto',
                    },
                  },
                  'image/png': {
                    schema: {
                      $ref: '#/components/schemas/ImageResponseDto',
                    },
                  },
                },
                description: 'Success',
              },
              400: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'image/gif': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'image/jpeg': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'image/png': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'Bad Request',
              },
              415: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'image/gif': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'image/jpeg': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'image/png': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'Client Error',
              },
            },
            summary: 'Generate an image of to provided pdf file',
            tags: [
              'Pdf',
            ],
          },
        },
        '/api/pdf/pdfwritestring': {
          post: {
            requestBody: {
              content: {
                'application/json': {
                  example: `{␍␊
                    "pdfFileBase64String": "<Encode your existing PDF document as Base64 encoded string>",␍␊
                    "options": {␍␊
                      "text": "This is test string",␍␊
                      "textColor": {␍␊
                        "r": 33,␍␊
                        "g": 34,␍␊
                        "b": 35␍␊
                      },␍␊
                      "font": {␍␊
                        "name": "Arial",␍␊
                        "size": 24.0,␍␊
                        "style": 1␍␊
                      },␍␊
                      "pageNumber": 3,␍␊
                      "xPosition": 40.0,␍␊
                      "yPosition": -200.0,␍␊
                      "xOrigin": 1,␍␊
                      "yOrigin": 2␍␊
                    },␍␊
                    "fontFileBase64String": "<Attach your own TrueTypeFont file if necessary to style text, encoded as Base64 encoded string>"␍␊
                  }`,
                  schema: {
                    $ref: '#/components/schemas/PdfWriteStringRequestDto',
                  },
                },
                'multipart/form-data': {
                  encoding: {
                    fontfile: {
                      contentType: 'application/octet-stream',
                    },
                    options: {
                      contentType: 'application/json',
                    },
                    pdfdocument: {
                      contentType: 'application/octet-stream',
                    },
                  },
                  schema: {
                    properties: {
                      fontfile: {
                        description: 'Optional entry to attach your own TrueType font file to style string',
                        format: 'binary',
                        type: 'string',
                      },
                      options: {
                        description: 'After pdfdocument is added, add an entry named options with your PdfWriteStringOptions object serialized as JSON.',
                        format: 'string',
                        type: 'string',
                      },
                      pdfdocument: {
                        description: 'An entry named pdfdocument is required in the multipart/form-data request',
                        format: 'binary',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                },
              },
              description: 'PdfWriteString Request. Write string on page in pdf document',
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                },
                description: 'Returns the newly created pdf file. Either the file directly or serialized as Json if Accept-header is set to application/json',
              },
              400: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If any error occurs parsing input',
              },
              415: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If content-type of request is not set to multipart/form-data or application/json',
              },
            },
            summary: 'Write text on a page in a pdf document.',
            tags: [
              'Pdf',
            ],
          },
        },
        '/api/pdf/wkhtmltopdf': {
          post: {
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                },
                description: 'Returns the newly created pdf file. Either the file directly or serialized as Json if Accept-header is set to application/json',
              },
              400: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If any error occurs executing request',
              },
              415: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If content-type of request is not set to application/json',
              },
            },
            summary: 'Generate pdf file from url using the excellent tool wkhtmltopdf.',
            tags: [
              'Pdf',
            ],
          },
        },
        '/api/pdf/xslfo': {
          post: {
            requestBody: {
              content: {
                'application/json': {
                  example: `{␍␊
                    "foDocumentBase64String": "<Encode your XSL-FO document as Base64 encoded string>",␍␊
                    "resources": {␍␊
                      "<Use file name as key, i.e 'logo.png', which is set as src on fo:external-graphic elements>": "<Convert your images to Base64 encoded string>"␍␊
                    }␍␊
                  }`,
                  schema: {
                    $ref: '#/components/schemas/FoRequestDto',
                  },
                },
                'multipart/form-data': {
                  encoding: {
                    fodocument: {
                      contentType: 'application/octet-stream',
                    },
                    resources: {
                      contentType: 'application/octet-stream',
                    },
                  },
                  schema: {
                    properties: {
                      fodocument: {
                        description: 'An entry named fodocument is required in the multipart/form-data request',
                        format: 'binary',
                        type: 'string',
                      },
                      resources: {
                        description: 'After fodocument is added, add all digital resources one by one to your multipart/form-data request, using the filename as name in the form.',
                        format: 'binary',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                },
              },
              description: 'XSL-FO Request, the basic XSL-FO request. Post your XSL-FO document and digital resources, either as \'multipart/form-data\' or \'application/json\'',
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                },
                description: 'Returns the newly created pdf file. Either the file directly or serialized as Json if Accept-header is set to application/json',
              },
              400: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If any error occurs parsing input',
              },
              415: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If content-type of request is not set to multipart/form-data or application/json',
              },
            },
            summary: 'Create pdf-file from complete XSL-FO document.',
            tags: [
              'Pdf',
            ],
          },
        },
        '/api/pdf/xslfowithtransform': {
          post: {
            requestBody: {
              content: {
                'application/json': {
                  example: `{␍␊
                    "xmlDataDocumentBase64String": "<This is the document which contains your data that the XSL-FO transform will be applied on. Send as Base64 encoded string>",␍␊
                    "foDocumentBase64String": "<Encode your XSL-FO transform document as Base64 encoded string>",␍␊
                    "resources": {␍␊
                      "<Use file name as key, i.e 'logo.png', which is set as src on fo:external-graphic elements>": "<Convert your images to Base64 encoded string>"␍␊
                    }␍␊
                  }`,
                  schema: {
                    $ref: '#/components/schemas/FoTransformRequestDto',
                  },
                },
                'multipart/form-data': {
                  encoding: {
                    fodocument: {
                      contentType: 'application/octet-stream',
                    },
                    resources: {
                      contentType: 'application/octet-stream',
                    },
                    xmldatadocument: {
                      contentType: 'application/octet-stream',
                    },
                  },
                  schema: {
                    properties: {
                      fodocument: {
                        description: 'An entry named fodocument with your XSL-FO transform is required in the multipart/form-data request',
                        format: 'binary',
                        type: 'string',
                      },
                      resources: {
                        description: 'After fodocument and xmldatadocument is added, add all digital resources one by one to your multipart/form-data request, using the filename as name in the form.',
                        format: 'binary',
                        type: 'string',
                      },
                      xmldatadocument: {
                        description: 'An entry named xmldatadocument, on which the XSL-FO transform is applied, is required in the multipart/form-data request',
                        format: 'binary',
                        type: 'string',
                      },
                    },
                    type: 'object',
                  },
                },
              },
              description: 'XSL-FO Transform Request. The XSL-FO is transformed on the supplied xml data document. Post your XSL-FO transform document and xml data document aloing with your digital resources, either as \'multipart/form-data\' or \'application/json\'',
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/PdfResponseDto',
                    },
                  },
                },
                description: 'Returns the newly created pdf file. Either the file directly or serialized as Json if Accept-header is set to application/json',
              },
              400: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If any error occurs parsing input',
              },
              415: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                  'application/pdf': {
                    schema: {
                      $ref: '#/components/schemas/ProblemDetails',
                    },
                  },
                },
                description: 'If content-type of request is not set to multipart/form-data or application/json',
              },
            },
            summary: 'Create pdf-file from transforming xml document with Xsl-Fo transform document.',
            tags: [
              'Pdf',
            ],
          },
        },
      },
      security: [
        {
          OAuth2: [
            'pdfbroker',
          ],
        },
      ],
    }

## parseOpenAPI success put

> Snapshot 1

    {
      info: {
        title: 'Fast API',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/': {
          put: {
            operationId: 'read_root__get',
            parameters: [
              {
                in: 'query',
                name: 'q',
                required: false,
                schema: {
                  title: 'Q',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
            },
            summary: 'Read Root',
          },
        },
      },
    }

## parseOpenAPI success randommer

> Snapshot 1

    {
      components: {
        schemas: {
          CaseType: {
            enum: [
              'LowerCase',
              'UpperCase',
              'SentenceCase',
              'TitleCase',
            ],
            type: 'string',
          },
          GetHash: {
            additionalProperties: false,
            properties: {
              key: {
                format: 'int32',
                type: 'integer',
              },
              text: {
                maxLength: 100000,
                type: 'string',
              },
            },
            required: [
              'text',
            ],
            type: 'object',
          },
          HashType: {
            enum: [
              'md5',
              'sha1',
              'sha256',
              'sha384',
              'sha512',
              'crc32',
              'caesarencryption',
              'caesardecryption',
            ],
            type: 'string',
          },
          LoremType: {
            enum: [
              'normal',
              'business',
            ],
            type: 'string',
          },
          NameType: {
            enum: [
              'firstname',
              'surname',
              'fullname',
            ],
            type: 'string',
          },
          TextActionType: {
            enum: [
              'Transform',
              'Replace',
            ],
            type: 'string',
          },
          TextDto: {
            additionalProperties: false,
            properties: {
              text: {
                nullable: true,
                type: 'string',
              },
            },
            type: 'object',
          },
          TextType: {
            enum: [
              'paragraphs',
              'words',
            ],
            type: 'string',
          },
        },
      },
      info: {
        title: 'Randommer API',
        version: 'v1',
      },
      openapi: '3.0.1',
      paths: {
        '/api/Card': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'type',
                schema: {
                  type: 'string',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Card',
            ],
          },
        },
        '/api/Card/Types': {
          get: {
            parameters: [
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Card',
            ],
          },
        },
        '/api/Hash': {
          post: {
            parameters: [
              {
                in: 'query',
                name: 'hashType',
                required: true,
                schema: {
                  $ref: '#/components/schemas/HashType',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            requestBody: {
              content: {
                'application/*+json': {
                  schema: {
                    $ref: '#/components/schemas/GetHash',
                  },
                },
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/GetHash',
                  },
                },
                'text/json': {
                  schema: {
                    $ref: '#/components/schemas/GetHash',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Hash',
            ],
          },
        },
        '/api/Name': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'nameType',
                required: true,
                schema: {
                  $ref: '#/components/schemas/NameType',
                },
              },
              {
                in: 'query',
                name: 'number',
                required: true,
                schema: {
                  format: 'int32',
                  maximum: 10000,
                  minimum: 1,
                  type: 'integer',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Name',
            ],
          },
        },
        '/api/Name/suggestions': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'startingWords',
                schema: {
                  type: 'string',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Name',
            ],
          },
        },
        '/api/Number': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'min',
                schema: {
                  default: 1,
                  format: 'int32',
                  maximum: 2147483646,
                  minimum: -2147483648,
                  type: 'integer',
                },
              },
              {
                in: 'query',
                name: 'max',
                schema: {
                  default: 100,
                  format: 'int32',
                  maximum: 2147483647,
                  minimum: -2147483647,
                  type: 'integer',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Number',
            ],
          },
        },
        '/api/Number/Sequence': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'min',
                schema: {
                  default: 1,
                  format: 'int32',
                  maximum: 1000,
                  minimum: 0,
                  type: 'integer',
                },
              },
              {
                in: 'query',
                name: 'max',
                schema: {
                  default: 100,
                  format: 'int32',
                  maximum: 12000,
                  minimum: 1,
                  type: 'integer',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      items: {
                        format: 'int32',
                        type: 'integer',
                      },
                      type: 'array',
                    },
                  },
                  'text/json': {
                    schema: {
                      items: {
                        format: 'int32',
                        type: 'integer',
                      },
                      type: 'array',
                    },
                  },
                  'text/plain': {
                    schema: {
                      items: {
                        format: 'int32',
                        type: 'integer',
                      },
                      type: 'array',
                    },
                  },
                },
                description: 'Success',
              },
            },
            tags: [
              'Number',
            ],
          },
        },
        '/api/Phone/Countries': {
          get: {
            parameters: [
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Phone',
            ],
          },
        },
        '/api/Phone/Generate': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'CountryCode',
                required: true,
                schema: {
                  maxLength: 2,
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'Quantity',
                required: true,
                schema: {
                  format: 'int32',
                  maximum: 1000,
                  minimum: 1,
                  type: 'integer',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Phone',
            ],
          },
        },
        '/api/Phone/Validate': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'telephone',
                required: true,
                schema: {
                  maxLength: 25,
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'CountryCode',
                schema: {
                  maxLength: 2,
                  type: 'string',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Phone',
            ],
          },
        },
        '/api/SocialNumber': {
          get: {
            parameters: [
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'SocialNumber',
            ],
          },
        },
        '/api/Text/Humanize': {
          post: {
            parameters: [
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            requestBody: {
              content: {
                'application/*+json': {
                  schema: {
                    $ref: '#/components/schemas/TextDto',
                  },
                },
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/TextDto',
                  },
                },
                'text/json': {
                  schema: {
                    $ref: '#/components/schemas/TextDto',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Text',
            ],
          },
        },
        '/api/Text/LoremIpsum': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'loremType',
                required: true,
                schema: {
                  $ref: '#/components/schemas/LoremType',
                },
              },
              {
                in: 'query',
                name: 'type',
                required: true,
                schema: {
                  $ref: '#/components/schemas/TextType',
                },
              },
              {
                in: 'query',
                name: 'number',
                required: true,
                schema: {
                  format: 'int32',
                  maximum: 2147483647,
                  minimum: 1,
                  type: 'integer',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Text',
            ],
          },
        },
        '/api/Text/Password': {
          get: {
            parameters: [
              {
                in: 'query',
                name: 'length',
                required: true,
                schema: {
                  format: 'int32',
                  maximum: 250,
                  minimum: 3,
                  type: 'integer',
                },
              },
              {
                in: 'query',
                name: 'hasDigits',
                required: true,
                schema: {
                  type: 'boolean',
                },
              },
              {
                in: 'query',
                name: 'hasUppercase',
                required: true,
                schema: {
                  type: 'boolean',
                },
              },
              {
                in: 'query',
                name: 'hasSpecial',
                required: true,
                schema: {
                  type: 'boolean',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Text',
            ],
          },
        },
        '/api/Text/Transform': {
          post: {
            parameters: [
              {
                in: 'query',
                name: 'textActionType',
                required: true,
                schema: {
                  $ref: '#/components/schemas/TextActionType',
                },
              },
              {
                in: 'query',
                name: 'caseType',
                schema: {
                  $ref: '#/components/schemas/CaseType',
                },
              },
              {
                in: 'query',
                name: 'find',
                schema: {
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'replace',
                schema: {
                  type: 'string',
                },
              },
              {
                description: 'Enter your key',
                in: 'header',
                name: 'X-Api-Key',
                schema: {
                  type: 'string',
                },
              },
            ],
            requestBody: {
              content: {
                'application/*+json': {
                  schema: {
                    $ref: '#/components/schemas/TextDto',
                  },
                },
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/TextDto',
                  },
                },
                'text/json': {
                  schema: {
                    $ref: '#/components/schemas/TextDto',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                description: 'Success',
              },
            },
            tags: [
              'Text',
            ],
          },
        },
      },
    }

## parseOpenAPI success remove-saasify-headers

> Snapshot 1

    {
      info: {
        title: 'Fast API',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/': {
          get: {
            operationId: 'read_root__get',
            parameters: [
              {
                in: 'header',
                name: 'x-saasify-user',
                schema: {
                  title: 'x-saasify-user',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                schema: {
                  title: 'x-saasify-plan',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'foo',
                schema: {
                  title: 'foo',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
            },
            summary: 'Read Root',
          },
        },
      },
    }

## parseOpenAPI success xkcd

> Snapshot 1

    {
      components: {
        schemas: {
          comic: {
            properties: {
              alt: {
                type: 'string',
              },
              day: {
                type: 'string',
              },
              img: {
                type: 'string',
              },
              link: {
                type: 'string',
              },
              month: {
                type: 'string',
              },
              news: {
                type: 'string',
              },
              num: {
                type: 'number',
              },
              safe_title: {
                type: 'string',
              },
              title: {
                type: 'string',
              },
              transcript: {
                type: 'string',
              },
              year: {
                type: 'string',
              },
            },
            type: 'object',
          },
        },
      },
      externalDocs: {
        url: 'https://xkcd.com/json.html',
      },
      info: {
        description: 'Webcomic of romance, sarcasm, math, and language.',
        title: 'XKCD',
        version: '1.0.0',
        'x-apisguru-categories': [
          'media',
        ],
        'x-logo': {
          url: 'http://imgs.xkcd.com/static/terrible_small_logo.png',
        },
        'x-origin': [
          {
            format: 'swagger',
            url: 'https://raw.githubusercontent.com/APIs-guru/unofficial_openapi_specs/master/xkcd.com/1.0.0/swagger.yaml',
            version: '2.0',
          },
        ],
        'x-providerName': 'xkcd.com',
        'x-tags': [
          'humor',
          'comics',
        ],
        'x-unofficialSpec': true,
      },
      openapi: '3.0.0',
      paths: {
        '/info.0.json': {
          get: {
            description: `Fetch current comic and metadata.␊
            `,
            responses: {
              200: {
                content: {
                  '*/*': {
                    schema: {
                      $ref: '#/components/schemas/comic',
                    },
                  },
                },
                description: 'OK',
              },
            },
          },
        },
        '/{comicId}/info.0.json': {
          get: {
            description: `Fetch comics and metadata  by comic id.␊
            `,
            parameters: [
              {
                in: 'path',
                name: 'comicId',
                required: true,
                schema: {
                  type: 'number',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  '*/*': {
                    schema: {
                      $ref: '#/components/schemas/comic',
                    },
                  },
                },
                description: 'OK',
              },
            },
          },
        },
      },
      servers: [
        {
          url: 'http://xkcd.com/',
        },
      ],
    }

## parseOpenAPI success zestful

> Snapshot 1

    {
      info: {
        title: 'Zestful',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/parseIngredients': {
          post: {
            description: 'Parses a list of raw ingredient strings into structured JSON.',
            requestBody: {
              content: {
                'application/json': {
                  example: {
                    ingredients: [
                      '3 large Granny Smith apples',
                      '2 1/2 tablespoons finely chopped parsley',
                      '½ tsp brown sugar',
                    ],
                  },
                  schema: {
                    additionalProperties: false,
                    properties: {
                      ingredients: {
                        description: `List of ingredients to parse.␊
                        - This list must contain between 1 and 100 elements.␊
                        - Each string in the list must be 1,024 characters or fewer.␊
                        - Unicode strings are supported.␊
                        - The strings may be HTML- or URL-encoded.␊
                        - Any HTML tags in the ingredient strings will be ignored.`,
                        items: {
                          type: 'string',
                        },
                        title: 'ingredients',
                        type: 'array',
                      },
                    },
                    required: [
                      'ingredients',
                    ],
                    type: 'object',
                  },
                },
              },
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {
                      properties: {
                        results: {
                          description: ' If the request was successful, contains a list of dictionaries with the keys `ingredientRaw`, `ingredientParsed`, and `error`.',
                          error: {
                            description: 'An error message that describes what caused the full parse request to fail.',
                            type: 'string',
                          },
                          items: {
                            properties: {
                              ingredientParsed: {
                                description: 'A dictionary containing the ingredient as structured data.',
                                properties: {
                                  confidence: {
                                    description: 'A value between 0.0 and 1.0 representing Zestful’s confidence in the result (higher is better).',
                                    type: 'number',
                                  },
                                  error: {
                                    description: 'An error message that describes what caused `ingredientRaw` to fail parsing.',
                                    type: 'string',
                                  },
                                  preparationNotes: {
                                    description: `Instructions to the user about how to prepare this ingredient for a recipe (e.g., `finely chopped`, `halved`).␊
                                    ␊
                                    - Preparation notes refer to actions that a user takes after purchasing an ingredient. In some cases, such as “ground cinnamon” this is ambiguous because a user can purchase whole cinnamon sticks and grind them (which would treat grinding as a preparation step) or a user can purchase the product `ground cinnamon` (which has no preparation steps).␊
                                    ␊
                                    - For ambiguous cases, the parser attempts to choose the product that is more common. For example, “ground cinnamon” is treated as a product name because most users purchase cinnamon pre-ground. In contrast, “diced celery” is interpreted as product=`celery`, preparationNotes=`diced` because users more commonly dice celery instead of buying pre-diced celery.`,
                                    type: 'string',
                                  },
                                  product: {
                                    description: 'The product a user buys to obtain this ingredient (e.g., `ground beef`, `brown sugar`).',
                                    type: 'string',
                                  },
                                  productSizeModifier: {
                                    description: 'Adjectives that describe product\'s size (e.g., `large`, `small`).',
                                    type: 'string',
                                  },
                                  quantity: {
                                    description: 'A number representing the quantity represented in the ingredient string, or null if no quantity was detected in the ingredient string.',
                                    oneOf: [
                                      {
                                        type: 'string',
                                      },
                                      {
                                        type: null,
                                      },
                                    ],
                                  },
                                  unit: {
                                    description: `A string containing the unit of measure in the ingredient string, or null if no unit of measure was found.␊
                                    The unit of measure is always in singular form (e.g., `teaspoon`, not `teaspoons`).`,
                                    oneOf: [
                                      {
                                        type: 'string',
                                      },
                                      {
                                        type: null,
                                      },
                                    ],
                                  },
                                  usdaInfo: {
                                    description: 'If Zestful can match the ingredient to a food in the USDA database, this contains a dictionary of information about the matching USDA entry',
                                    properties: {
                                      category: {
                                        description: 'The USDA category for the ingredient (e.g., `Sweets`).',
                                        type: 'string',
                                      },
                                      description: {
                                        description: 'The name of the ingredient in the USDA database (e.g., `Sugars, brown`).',
                                        type: 'string',
                                      },
                                      fdcId: {
                                        description: 'The FDC ID for the food in the USDA FoodData Central database (e.g., `168833`)',
                                        type: 'string',
                                      },
                                      matchMethod: {
                                        description: `The method that Zestful used to match the ingredient to a USDA entry. This can be one of the following values:␊
                                        ␊
                                        - `exact`: Zestful found an exact match for this product in the USDA database.␊
                                        - `closestUnbranded`: Zestful could not find an exact equivalent USDA entry, so it matched the ingredient to a closely related unbranded USDA product.␊
                                        - e.g., USDA has no exact match for `light brown sugar`, so Zestful would match this ingredient to `Sugars, brown`.␊
                                        - `closestBranded`: Zestful could not find an exact or unbranded equivalent USDA entry, so it matched the ingredient to a branded USDA product.␊
                                        - e.g., USDA has no exact match for `apple cider vinegar`, so Zestful would match this ingredient to `BRAGG, ORGANIC APPLE CIDER VINEGAR`.`,
                                        enum: [
                                          'exact',
                                          'closestUnbranded',
                                          'closestBranded',
                                        ],
                                        type: 'string',
                                      },
                                    },
                                    type: 'object',
                                  },
                                },
                                type: 'object',
                              },
                              ingredientRaw: {
                                type: 'string',
                              },
                            },
                            type: 'object',
                          },
                          title: 'results',
                          type: 'array',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'Successful Response',
              },
            },
            summary: 'Parse Ingredients',
          },
        },
      },
      servers: [
        {
          url: 'https://sandbox.zestfuldata.com',
        },
      ],
    }

## parseOpenAPI success solder

> Snapshot 1

    {
      components: {
        schemas: {
          ChangeableTapTargetData: {
            properties: {
              api_key: {
                title: 'Api Key',
                type: 'string',
              },
              postgres_database: {
                title: 'Postgres Database',
                type: 'string',
              },
              postgres_host: {
                title: 'Postgres Host',
                type: 'string',
              },
              postgres_password: {
                title: 'Postgres Password',
                type: 'string',
              },
              postgres_port: {
                title: 'Postgres Port',
                type: 'integer',
              },
              postgres_schema: {
                title: 'Postgres Schema',
                type: 'string',
              },
              postgres_username: {
                title: 'Postgres Username',
                type: 'string',
              },
              url: {
                title: 'Url',
                type: 'string',
              },
            },
            title: 'ChangeableTapTargetData',
            type: 'object',
          },
          HTTPValidationError: {
            properties: {
              detail: {
                items: {
                  $ref: '#/components/schemas/ValidationError',
                },
                title: 'Detail',
                type: 'array',
              },
            },
            title: 'HTTPValidationError',
            type: 'object',
          },
          TapTargetData: {
            properties: {
              api_key: {
                title: 'Api Key',
                type: 'string',
              },
              postgres_database: {
                title: 'Postgres Database',
                type: 'string',
              },
              postgres_host: {
                title: 'Postgres Host',
                type: 'string',
              },
              postgres_password: {
                title: 'Postgres Password',
                type: 'string',
              },
              postgres_port: {
                title: 'Postgres Port',
                type: 'integer',
              },
              postgres_schema: {
                title: 'Postgres Schema',
                type: 'string',
              },
              postgres_username: {
                title: 'Postgres Username',
                type: 'string',
              },
              url: {
                title: 'Url',
                type: 'string',
              },
            },
            required: [
              'url',
              'api_key',
              'postgres_host',
              'postgres_port',
              'postgres_database',
              'postgres_username',
              'postgres_password',
              'postgres_schema',
            ],
            title: 'TapTargetData',
            type: 'object',
          },
          ValidationError: {
            properties: {
              loc: {
                items: {
                  type: 'string',
                },
                title: 'Location',
                type: 'array',
              },
              msg: {
                title: 'Message',
                type: 'string',
              },
              type: {
                title: 'Error Type',
                type: 'string',
              },
            },
            required: [
              'loc',
              'msg',
              'type',
            ],
            title: 'ValidationError',
            type: 'object',
          },
        },
      },
      info: {
        title: 'FastAPI',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/activecampaign-postgres/add-data/': {
          post: {
            description: `This endpoint allows the user to add their ActiveCampaign and Postgres data␊
            ␊
            This will allow the user to add their ActiveCampaign and Postgres data.`,
            operationId: 'add_data_activecampaign_postgres_add_data__post',
            parameters: [
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/TapTargetData',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Add Data',
          },
        },
        '/activecampaign-postgres/end-job/': {
          get: {
            description: `This endpoint will end a current running job if there is one␊
            ␊
            This will allow the user to end a job that they have running.␊
            ␊
            Input:␊
            ␊
            * category: "deals | contacts"`,
            operationId: 'end_job_activecampaign_postgres_end_job__get',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'End Job',
          },
        },
        '/activecampaign-postgres/get-current-running-jobs/': {
          get: {
            description: `Get your current list of running jobs␊
            ␊
            This will let the user retrieve a list of all of his running jobs as well as their current CRON strings.`,
            operationId: 'get_current_running_jobs_activecampaign_postgres_get_current_running_jobs__get',
            parameters: [
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Get Current Running Jobs',
          },
        },
        '/activecampaign-postgres/get-data/': {
          get: {
            description: `This endpoint retrieves the information regarding a current user␊
            ␊
            This will allow the user to retrieve data regarding their ActiveCampaign and Postgres data.`,
            operationId: 'get_data_activecampaign_postgres_get_data__get',
            parameters: [
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Get Data',
          },
        },
        '/activecampaign-postgres/modify-current-job/': {
          put: {
            description: `This endpoint modifies the CRON string of a current running job␊
            ␊
            This will allow the user to modify a job that they have running.␊
            ␊
            Input:␊
            ␊
            * category: "deals | contacts"␊
            * cron: a valid CRON string`,
            operationId: 'modify_current_job_activecampaign_postgres_modify_current_job__put',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'cron',
                required: true,
                schema: {
                  title: 'Cron',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Modify Current Job',
          },
        },
        '/activecampaign-postgres/modify-data/': {
          put: {
            description: `This endpoint allows the user to modify their ActiveCampaign and Postgres data␊
            ␊
            This will allow the user to modify their ActiveCampaign and Postgres data. ␊
            Note that the JSON object below does not have to include every field. It can only include the data you want to change.`,
            operationId: 'modify_data_activecampaign_postgres_modify_data__put',
            parameters: [
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/ChangeableTapTargetData',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Modify Data',
          },
        },
        '/activecampaign-postgres/perform-etl-all-data/': {
          get: {
            description: `This endpoint allows the user to transfer both their contacts and deals data from ActiveCampaign to Postgres at once␊
            ␊
            This will allow the user to transfer their ActiveCampaign data to Postgres without specifying category.`,
            operationId: 'perform_etl_all_data_activecampaign_postgres_perform_etl_all_data__get',
            parameters: [
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Perform Etl All Data',
          },
        },
        '/activecampaign-postgres/perform-etl-by-category/': {
          get: {
            description: `This endpoint allows the user to perform an ETL transfer between ActiveCampaign and Postgres data by category␊
            ␊
            This will allow the user to transfer their ActiveCampaign data to Postgres by category.␊
            ␊
            Input:␊
            * category: "deals | contacts"`,
            operationId: 'perform_etl_by_category_activecampaign_postgres_perform_etl_by_category__get',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Perform Etl By Category',
          },
        },
        '/activecampaign-postgres/start-job/': {
          get: {
            description: `This endpoint creates a new job␊
            ␊
            This will allow the user to create an entirely new job if they do not have one running already.␊
            ␊
            Input:␊
            ␊
            * category: "deals | contacts"␊
            * cron: a valid CRON string`,
            operationId: 'start_job_activecampaign_postgres_start_job__get',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'cron',
                required: true,
                schema: {
                  title: 'Cron',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-user',
                required: false,
                schema: {
                  title: 'X-Saasify-User',
                  type: 'string',
                },
              },
              {
                in: 'header',
                name: 'x-saasify-plan',
                required: false,
                schema: {
                  title: 'X-Saasify-Plan',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
            },
            summary: 'Start Job',
          },
        },
      },
    }

## parseOpenAPI success empty

> Snapshot 1

    {
      info: {
        title: 'Empty OpenAPI test',
        version: '0.1.0',
      },
      openapi: '3.0.2',
      paths: {},
    }
