# Snapshot report for `lib/annotate-openapi.test.js`

The actual snapshot is saved in `annotate-openapi.test.js.snap`.

Generated by [AVA](https://avajs.dev).

## annotateOpenAPI googio

> Snapshot 1

    {
      components: {
        schemas: {
          HTTPValidationError: {
            properties: {
              detail: {
                items: {
                  $ref: '#/components/schemas/ValidationError',
                },
                title: 'Detail',
                type: 'array',
              },
            },
            title: 'HTTPValidationError',
            type: 'object',
          },
          ValidationError: {
            properties: {
              loc: {
                items: {
                  type: 'string',
                },
                title: 'Location',
                type: 'array',
              },
              msg: {
                title: 'Message',
                type: 'string',
              },
              type: {
                title: 'Error Type',
                type: 'string',
              },
            },
            required: [
              'loc',
              'msg',
              'type',
            ],
            title: 'ValidationError',
            type: 'object',
          },
        },
        securitySchemes: {
          'API Key': {
            description: `Optional API key for authenticated access.␊
            ␊
            ␊
            Unauthenticated (public) requests are subject to rate limiting. See [pricing](/pricing) for specifics on these rate limits.␊
            ␊
            You can view and manage your API key in the [Dashboard](/dashboard).␊
            ␊
            Be sure to keep your API key secure. Do not share it in publicly accessible areas such as GitHub, client-side code, and so forth.␊
            ␊
            All API requests must be made over HTTPS. Calls made over plain HTTP will fail.`,
            in: 'header',
            name: 'Authorization',
            type: 'apiKey',
          },
        },
      },
      info: {
        contact: {
          email: 'support@saasify.sh',
          name: 'API Support',
        },
        termsOfService: '/terms',
        title: 'googio',
        version: 'v0.0.6',
      },
      openapi: '3.0.2',
      paths: {
        '/googio/googio@d6fdca5e/api/v1/search/{query}': {
          get: {
            description: `Perform Google Search␊
            ␊
            Parameters␊
            ----------␊
            query : the string query to perform search. supports advance queries. Check out [https://moz.com/blog/the-ultimate-guide-to-the-google-search-parameters] guide for formating␊
            ␊
            Returns␊
            -------␊
            json: a list of results with the link, description, and title for each result`,
            operationId: 'Search',
            parameters: [
              {
                examples: {
                  'regular keyword search': {
                    value: 'q=google+search+api',
                  },
                  'regular keyword search with 100 results': {
                    value: 'q=google+search+api&num=100',
                  },
                },
                in: 'path',
                name: 'query',
                required: true,
                schema: {
                  title: 'Query',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      'search for instagram with 100 results': {
                        value: {
                          answer: null,
                          results: [
                            {
                              description: 'Create an account or log in to Instagram - A simple, fun & creative way to capture, edit & share photos, videos & messages with friends & family.',
                              link: 'https://www.instagram.com/',
                              title: 'Instagram',
                            },
                            {
                              description: 'Bringing you closer to the people and things you love. — Instagram from Facebook Connect with friends, share what you\'re up to, or see what\'s new from others ...',
                              link: 'https://play.google.com/store/apps/details?id=com.instagram.android&hl=en_US',
                              title: 'Instagram - Apps on Google Play',
                            },
                            {
                              description: 'Read reviews, compare customer ratings, see screenshots, and learn more about Instagram. Download Instagram and enjoy it on your iPhone, iPad, and iPod ...',
                              link: 'https://apps.apple.com/us/app/instagram/id389801252',
                              title: '‎Instagram on the App Store',
                            },
                            {
                              description: 'Instagram · June 10 at 4:35 PM ·. These powerful posts from the Black community embody resilience and hope ...',
                              link: 'https://www.facebook.com/instagram/',
                              title: 'Instagram - Home | Facebook',
                            },
                            {
                              description: 'Instagram is an American photo and video-sharing social networking service owned by Facebook, Inc. It was created by Kevin Systrom and Mike Krieger, and ...',
                              link: 'https://en.wikipedia.org/wiki/Instagram',
                              title: 'Instagram - Wikipedia',
                            },
                            {
                              description: '2 days ago - Instagram. June 2020. Online influencers under fire for blacking ...',
                              link: 'https://www.theguardian.com/technology/instagram',
                              title: 'Instagram | Technology | The Guardian',
                            },
                            {
                              description: '1 day ago - Then, on May 25, George Floyd was killed in police custody in Minneapolis, sparking protests around the country. Instagram had already been a ...',
                              link: 'https://www.nytimes.com/2020/06/11/arts/design/art-accounts-to-follow-on-instagram.html',
                              title: 'Five Art Accounts to Follow on Instagram Now - The New York ...',
                            },
                            {
                              description: 'May 20, 2020 - Instagram is testing a feature that allows Insta users to share their live streams directly to IGTV as soon as the broadcast is over. These lives don\'t ...',
                              link: 'https://adespresso.com/blog/instagram-updates-you-need-to-make/',
                              title: 'Top Instagram Updates in 2020 - May Edition - AdEspresso',
                            },
                            {
                              description: 'Learn how to create captivating visuals, grow your following, and drive engagement on Instagram.',
                              link: 'https://www.hubspot.com/instagram-marketing',
                              title: 'Instagram Marketing: The Ultimate Guide - HubSpot',
                            },
                            {
                              description: '2 days ago - It\'s a nice tool to diversify your Instagram feed and engage more of your followers - and it can, indeed, add a “wow” factor to your social marketing.',
                              link: 'https://www.socialmediatoday.com/news/5-tools-to-boost-your-instagram-marketing-efforts-in-2020/579612/',
                              title: '5 Tools to Boost Your Instagram Marketing Efforts in 2020 ...',
                            },
                            {
                              description: 'Learn more about Instagram brand resources and download the Instagram logos, images, screenshots and more you need for your project.',
                              link: 'https://instagram-brand.com/',
                              title: 'Instagram Brand Resources',
                            },
                            {
                              description: 'Jan 9, 2019 - Everything you need to know about using Instagram for business—from setting up your account to creating a winning strategy.',
                              link: 'https://blog.hootsuite.com/how-to-use-instagram-for-business/',
                              title: 'How to Use Instagram for Business: A Simple 6-Step Guide',
                            },
                            {
                              description: '1 day ago - Actor Keegan Allen and influencer Olivia Jade are among two popular Instagram accounts that used the "BLM — Donate Now" filter.',
                              link: 'https://www.insider.com/influencers-promote-black-lives-matter-donation-instagram-ar-filter-2020-6',
                              title: 'Influencers promote Black Lives Matter donation Instagram AR ...',
                            },
                            {
                              description: '8 hours ago - If you scroll all the way down to Kylie Jenner\'s first Instagram posts, you\'ll see that she, too, once fell victim to the duck face selfie and sepia filter ...',
                              link: 'https://www.yahoo.com/lifestyle/kylie-jenner-very-first-instagram-154018364.html',
                              title: 'Kylie Jenner\'s first Instagram posts are unbelievably normal ...',
                            },
                            {
                              description: 'Nicki Minaj CRUSHES Instagram With New Bangin\' Booty Photos With Tekashi 6ix9ine!! Instagram. Jun 11, 2020 at 20:59 pm UTC By Mike Walters · Nicki Minaj ...',
                              link: 'https://theblast.com/c/nicki-minaj-tekashi-6ix9ine-69-trollz-photos-video-smoking-hot-pictures-instagram-rainbow-wig',
                              title: 'Nicki Minaj CRUSHES Instagram With New Bangin\' Booty ...',
                            },
                            {
                              description: 'Everything you need to know about using Instagram Stories. From posting and scheduling stories, using stickers, and everything in-between.',
                              link: 'https://buffer.com/library/instagram-stories/',
                              title: 'Instagram Stories: The Complete Guide to Creating Standout ...',
                            },
                            {
                              description: '1 day ago - Instagram has a bad reputation for negatively influencing the way people see themselves. But a new study shows that its influence can be ...',
                              link: 'https://www.ecowatch.com/exercise-study-instagram-2646169143.html',
                              title: 'Instagram Gets Couch Potatoes Up and Running, Study Says ...',
                            },
                            {
                              description: '3 days ago - Instagram lets you add a call to action (CTA) to your ads that goes to a landing page, but you can only add a link to one page. This is why if you\'re ...',
                              link: 'https://www.socialmediaexaminer.com/how-to-improve-instagram-video-ads-5-tips/',
                              title: 'How to Improve Your Instagram Video Ads: 5 Tips : Social ...',
                            },
                            {
                              description: 'Instagram allows users to edit and upload photos and short videos through a mobile app. Users can add a caption to each of their posts and use hashtags and ...',
                              link: 'https://searchcio.techtarget.com/definition/Instagram',
                              title: 'What is Instagram? - Definition from WhatIs.com - SearchCIO',
                            },
                            {
                              description: 'Grow your Instagram and Facebook presence with exclusive insights and best-in-class management tools for your team. Start a 14-day Free Trial.',
                              link: 'https://pro.iconosquare.com/',
                              title: 'Iconosquare - Instagram & Facebook Analytics and ...',
                            },
                            {
                              description: 'Save Time by Scheduling Your Instagram Posts Ahead of Time. Manage Multiple Accounts, Schedule Video, Reposting, Analytics & Uploading Tools.',
                              link: 'https://later.com/',
                              title: 'Later: #1 Instagram Scheduler & Social Media Platform',
                            },
                            {
                              description: '1 day ago - Benafsha Soonawala says that her recent nude picture was removed by Instagram. Check out her latest post.',
                              link: 'https://www.hindustantimes.com/tv/benafsha-soonawala-says-instagram-removed-her-topless-pic-they-couldn-t-take-such-extra-hotness/story-ldS0SdnqMwacVxRCK5zfnO.html',
                              title: 'Benafsha Soonawala says Instagram removed her topless pic ...',
                            },
                            {
                              description: 'May 27, 2020 - Ads will start showing up on Instagram\'s IGTV product as the company begins working with creators like Lele Pons and Adam Waheed as well ...',
                              link: 'https://www.theverge.com/2020/5/27/21271009/instagram-ads-igtv-live-badges-test-update-creators',
                              title: 'Instagram will share revenue with creators for the first time ...',
                            },
                            {
                              description: 'Dec 3, 2019 - How many people use Instagram? In June 2018, Instagram had reached one billion monthly active users, up from 800 million in September ...',
                              link: 'https://www.statista.com/statistics/253577/number-of-monthly-active-instagram-users/',
                              title: '• Instagram: active users 2018 | Statista',
                            },
                            {
                              description: 'Why You Should Follow Them: For fun artwork, puns, and extremely important conversations. 3. ZHK DESIGNS. Instagram. View this photo on ...',
                              link: 'https://www.buzzfeed.com/sumedha_bharpilania/21-desi-illustrators-you-need-to-follow-on-instagram-right',
                              title: '21 Desi Artists You Absolutely Need To Follow On Instagram',
                            },
                            {
                              description: 'Jun 4, 2020 - Instagram does not provide users of its embedding API a copyright license to display embedded images on other websites, the company said in ...',
                              link: 'https://arstechnica.com/tech-policy/2020/06/instagram-just-threw-users-of-its-embedding-api-under-the-bus/',
                              title: 'Instagram just threw users of its embedding API under the bus ...',
                            },
                            {
                              description: '10 hours ago - Black Owned Tour” is an Instagram account dedicated to highlighting local black-owned businesses.',
                              link: 'https://www.10tv.com/article/news/local/instagram-account-shines-light-on-local-black-owned-businesses/530-308237a8-958e-4a4d-b7c7-7ab2949ee935',
                              title: 'Instagram account shines light on local black-owned businesses',
                            },
                            {
                              description: 'Jun 3, 2020 - This extension better than a mobile version of Instagram! View and upload IG Story and other functions in your browser.',
                              link: 'https://chrome.google.com/webstore/detail/web-for-instagram/bonieeblbnamfclndbgnhblogabjijbp?hl=en-US',
                              title: 'Web for Instagram™ - Google Chrome',
                            },
                            {
                              description: 'Try our new tools for Instagram™: download photo, video and stories, view Live, mass download, direct message, upload photo.',
                              link: 'https://chrome.google.com/webstore/detail/downloader-for-instagram/olkpikmlhoaojbbmmpejnimiglejmboe?hl=en',
                              title: 'Downloader for Instagram™ + Direct Message - Google Chrome',
                            },
                            {
                              description: 'Feb 26, 2016 - Download this app from Microsoft Store for Windows 10. See screenshots, read the latest customer reviews, and compare ratings for Instagram.',
                              link: 'https://www.microsoft.com/en-us/p/instagram/9nblggh5l9xt',
                              title: 'Get Instagram - Microsoft Store',
                            },
                            {
                              description: 'The 6 best #GolfWRX photos on Instagram today (6.11.20). Published. 13 hours ago. on. Jun 11, 2020. By. Gianni Magliocco. Share; Tweet. In this segment ...',
                              link: 'http://www.golfwrx.com/614302/the-6-best-golfwrx-photos-on-instagram-today-6-11-20/',
                              title: 'The 6 best #GolfWRX photos on Instagram today (6.11.20 ...',
                            },
                            {
                              description: 'May 19, 2020 - Starting today, you\'ll be able to browse and buy products directly from a business\' Facebook Page or Instagram profile. Both Facebook and ...',
                              link: 'https://techcrunch.com/2020/05/19/facebook-shops/',
                              title: 'Facebook and Instagram roll out Shops, turning business ...',
                            },
                            {
                              description: '3 days ago - On Wednesday, 50 white celebrity women will hand over their Instagram accounts to 50 black women for the day to foster dialogue and reach ...',
                              link: 'https://www.forbes.com/sites/martyswant/2020/06/09/how-bozoma-saint-john-is-amplifying-black-voices-through-white-celebrities-instagram-accounts/',
                              title: 'How Bozoma Saint John Is Amplifying Black Voices Through ...',
                            },
                            {
                              description: 'Instagram photo, video, and IGTV downloader - Free, online, and one-click download.',
                              link: 'https://downloadgram.com/',
                              title: 'DownloadGram - Instagram photo, video and IGTV ...',
                            },
                            {
                              description: 'Feb 18, 2020 - The Instagram Money Calculator estimates earnings for Instagram Influencers. The Instagram Engagement Rate Calculator is a quick way to ...',
                              link: 'https://influencermarketinghub.com/instagram-money-calculator/',
                              title: 'Instagram Money Calculator (Instagram Influencer ...',
                            },
                            {
                              description: 'BBC News, 1 May. https://www.bbc.com/news/world-africa-36132482 Zappavigna, M. (2016). \'Social media photography: Construing subjectivity in Instagram ...',
                              link: 'https://books.google.com/books?id=_QHMDwAAQBAJ&pg=PT208&lpg=PT208&dq=instagram&source=bl&ots=kx1k9_bjvs&sig=ACfU3U28VuLB9EfcIJIJs-Dykyl6zC_Adw&hl=en&sa=X&ved=2ahUKEwjt3fTus_3pAhXsgnIEHTjKBZcQ6AEwRHoECG0QAQ',
                              title: 'Instagram: Visual Social Media Cultures - Google Books Result',
                            },
                            {
                              description: 'To log in to your Instagram account and order products in your store, you must now have an Instagram Business account associated with a Facebook Page.',
                              link: 'https://www.hivency.com/login-instagram-account/',
                              title: 'Login Instagram Account | Hivency',
                            },
                            {
                              description: 'IN THIS CHAPTER Finding Instagram apps for your device or computer Deploying Instagram apps on Windows and Mac computers Installing Instagram apps on ...',
                              link: 'https://books.google.com/books?id=9JJFDwAAQBAJ&pg=PT16&lpg=PT16&dq=instagram&source=bl&ots=dvTKF3C37q&sig=ACfU3U0L59-z1pbR2BHuJlOafe3G5SjXcw&hl=en&sa=X&ved=2ahUKEwjt3fTus_3pAhXsgnIEHTjKBZcQ6AEwRnoECG8QAQ',
                              title: 'Instagram For Business For Dummies - Google Books Result',
                            },
                            {
                              description: 'Download Instagram followers, comments and likes to excel and Google Sheets ... 4 May 2020 Type up your Instagram bio and copy and paste your favorite font ...',
                              link: 'http://vistaballoon.com/o51fbzs/how-to-copy-comments-from-instagram.html',
                              title: 'How to copy comments from instagram',
                            },
                            {
                              description: 'Apr 12, 2020 - The following tips can help you make the best out of your own Instagram experience so you can grow your followers and increase engagement.',
                              link: 'https://www.lifewire.com/instagram-tips-for-beginners-3485872',
                              title: '11 Instagram Tips for Beginners - Lifewire',
                            },
                            {
                              description: '23 hours ago - Vanessa Bryant got tattoos to honor her husband Kobe and daughter Gianna in February, according to her tattoo artist\'s Instagram . TMZ Sports ...',
                              link: 'https://bleacherreport.com/articles/2895859-vanessa-bryant-reveals-tattoos-honoring-kobe-gianna-on-instagram',
                              title: 'Vanessa Bryant Reveals Tattoos Honoring Kobe, Gianna on ...',
                            },
                            {
                              description: '1 day ago - Suzanne Somers, 73, reunites with her lookalike granddaughter Violet Somers, 22, in new Instagram video. By Sarah Sotoodeh For ...',
                              link: 'https://www.dailymail.co.uk/tvshowbiz/article-8410969/Suzanne-Somers-reunites-lookalike-granddaughter-Violet-Somers-new-Instagram-video.html',
                              title: 'Suzanne Somers reunites with her lookalike granddaughter ...',
                            },
                            {
                              description: '10 hours ago - @fairybonesmusic. Part of what makes Fairy Bones\' Instagram feed fun is because you\'re witnessing a band become stars right before your eyes, ...',
                              link: 'https://www.phoenixnewtimes.com/music/best-phoenix-music-instagram-accounts-11406390',
                              title: '20 Best Valley Music Instagram Accounts | Phoenix New Times',
                            },
                            {
                              description: 'You can generate unlimited Likes/Followers for Instagram. com is the best instagram auto liker!Here, you\'ll find instagram auto liker, instagram auto followers.',
                              link: 'http://brittocharette.com/x77c/free-unlimited-likes-on-instagram.html',
                              title: 'Free unlimited likes on instagram - Britto Charette',
                            },
                            {
                              description: 'Will The Protests Change Instagram for Good? Maybe. Probably Not. by Andrea Whittle. June 12, 2020 1:01 pm. Cindy Sherman - December 2017.',
                              link: 'https://www.wmagazine.com/story/instagram-armchair-activism-influencers-protests/',
                              title: 'Is This The End Of Instagram As We Know It? | W Magazine ...',
                            },
                            {
                              description: 'Apr 24, 2018 - Instagram\'s Snapchat-like feature lets you create sequences of photos and videos that expire after a day. Now with type mode in Stories!',
                              link: 'https://www.cnet.com/how-to/how-to-use-instagram-stories/',
                              title: 'Instagram Stories: Everything you need to know - CNET',
                            },
                            {
                              description: 'Download Followers Track for Instagram! and enjoy it on your iPhone, iPad, and iPod touch. 6 Software is available for free download: Checker Version 4.',
                              link: 'http://marinermedia.com/ik3jcdgzk/instagram-checker-download.html',
                              title: 'Instagram checker download - Mariner Media',
                            },
                            {
                              description: '5 hours ago - Note: These screenshots were captured in the Instagram application on iOS. Step 1: Once you\'ve taken or imported a video in Stories, tap the ...',
                              link: 'https://www.adweek.com/digital/instagram-heres-how-to-use-the-sound-on-sticker-in-stories/',
                              title: 'Instagram: Here\'s How to Use the Sound On Sticker in Stories ...',
                            },
                            {
                              description: '7 hours ago - Instagram has always been an accessible way to armchair travel. During the COVID-19 pandemic, the platform has offered a view of ...',
                              link: 'https://www.artsy.net/article/artsy-editorial-7-curators-instagram-provide-access-museums-quarantine',
                              title: '7 Curators Using Instagram to Provide Access to Museums ...',
                            },
                            {
                              description: '2019 Instagram music ใน story ทำไมของผมใช้ได้ครับ. And 80% of Instagram users come from outside of the United States! I guess a picture really is worth a ...',
                              link: 'http://goodcheer.org/bgf7/instagram-music.html',
                              title: 'Instagram music - Good Cheer Food Bank',
                            },
                            {
                              description: 'For less than $70, you can get 10,000 Instagram followers! That\'s enough to start elbowing your way into this industry. It\'s possible and fairly simple to go live on ...',
                              link: 'http://gynecologysurgeons.com/mgvnj/merge-instagram-followers.html',
                              title: 'Merge instagram followers',
                            },
                            {
                              description: '7 hours ago - Okay, not really, but back when Instagram was just a few years old, they definitely used it like us. Case in point: If you scroll all the way down to ...',
                              link: 'https://www.intheknow.com/2020/06/12/kylie-jenners-very-first-instagram-posts-are-just-as-basic-as-everyone-elses/',
                              title: 'Kylie Jenner\'s very first Instagram posts are just as basic as ...',
                            },
                            {
                              description: 'row2k Features. row2k features > row2k Exclusives. InstaRowing. This Week\'s Best of Rowing on Instagram 6/12/2020. June 12, 2020. Erik Dresser, row2k.com.',
                              link: 'https://www.row2k.com/features/4017/This-Week-s-Best-of-Rowing-on-Instagram-6-12-2020/',
                              title: 'This Week\'s Best of Rowing on Instagram 6/12/2020 - Row2k',
                            },
                            {
                              description: '9 hours ago - Yuzvendra Chahal took to Instagram on Friday to post a video of him bowling an impressive leg-spinner to knock over New Zealand batsman ...',
                              link: 'https://sports.ndtv.com/cricket/yuzvendra-chahal-trolls-uncle-chris-gayle-praises-kuldeep-yadav-on-instagram-2245380',
                              title: 'Yuzvendra Chahal Trolls "Uncle" Chris Gayle, Praises ...',
                            },
                            {
                              description: '9 hours ago - Thanks to her edgy social media presence, this model, photographer, blogger, and painter has become a true Instagram sensation with 4.5 ...',
                              link: 'https://www.boredpanda.com/weird-instagram-photography-digital-art-ellen-sheidlin/',
                              title: 'This Russian Artist Gained 4.5M Followers On Instagram ...',
                            },
                            {
                              description: 'Open the instagram profile of the user whose profile picture you want to download. ... To Download instagram photos just enter the URL of instagram photo in ...',
                              link: 'http://rhodeislanddentalmn.com/gc3/instagram-profile-download-free.html',
                              title: 'Instagram profile download free - Rhode Island Dental',
                            },
                            {
                              description: '1 day ago - Elizabeth Hurley posed in the bath with her arms in the air to mark her 55th birthday on InstagramCredit: Instagram. And other stars are striking ...',
                              link: 'https://www.thesun.co.uk/news/11843276/celebrity-instagram-poses-hidden-meanings/',
                              title: 'celebrities\' favourite Instagram poses and the ... - The Sun',
                            },
                            {
                              description: '21 hours ago - Bucs TE Rob Gronkowski bid farewell to his hairy companion Mr. Stache today on Instagram.',
                              link: 'https://bucswire.usatoday.com/2020/06/11/gronk-bids-farewell-to-mr-stache-on-instagram/',
                              title: 'Gronk bids farewell to Mr. Stache on Instagram - Bucs Wire',
                            },
                            {
                              description: '100k free Instagram likes and free Instagram followers! Home Free Instagram Likes And Followers Welcome to FREEGramLikes. The free likes will increase your ...',
                              link: 'http://wafels.be/xmpj7/how-to-get-5000-followers-on-instagram.html',
                              title: 'How to get 5000 followers on instagram - Wafels',
                            },
                            {
                              description: '17 hours ago - Need some training inspiration? You\'ll find workouts for all levels on our Instagram page.',
                              link: 'https://www.coachmag.co.uk/home-workouts/8596/follow-coach-on-instagram-for-video-workouts-from-top-pts',
                              title: 'Follow Coach On Instagram For Video Workouts From Top PTs',
                            },
                            {
                              description: '7 hours ago - OAKLAND — Federal prosecutors have charged an Alameda County man with posing as a 14-year-old girl on Instagram in order to lure boys ...',
                              link: 'https://www.mercurynews.com/feds-alameda-man-posed-as-teen-girl-on-instagram-to-lure-boys',
                              title: 'Feds: Alameda man posed as teen girl on Instagram to lure boys',
                            },
                            {
                              description: 'In this post, I share the step-by-step instructions on how to create a new location on Instagram. In online mode, the App will use cell towers to determine the ...',
                              link: 'http://salmonriverbrewery.com/qzdrls/does-instagram-track-location.html',
                              title: 'Does instagram track location - Salmon River Brewery',
                            },
                            {
                              description: '5 hours ago - In the Zoom segment leaked to Instagram on June 10, Vaksman says, “Because most of the trouble coming from where? From black people.',
                              link: 'https://qns.com/story/2020/06/12/st-johns-university-fires-coach-after-racist-comments-leak-on-instagram/',
                              title: 'St. John\'s University fires coach after racist comments leak on ...',
                            },
                            {
                              description: '46 mins ago - The app has a usability issue for hearing-impaired people and doesn\'t caption videos. In response, at least one Instagram account is manually ...',
                              link: 'https://www.capradio.org/articles/2020/06/12/volunteers-add-captions-to-black-lives-matter-instagram-videos-to-help-hard-of-hearing-community/',
                              title: 'Volunteers Add Captions To Black Lives Matter Instagram ...',
                            },
                            {
                              description: '8 hours ago - This list of 102 Black makers, crafters, designers, gardeners, and musicians will help enrich your Instagram feed and support Black-owned ...',
                              link: 'https://www.countryliving.com/life/inspirational-stories/a32791453/black-instagram-accounts-interior-designers-crafters/',
                              title: '102 Black Instagram Accounts to Follow for Home Design ...',
                            },
                            {
                              description: '5 hours ago - In several Instagram posts, some dating back to at least 2016, Realtor Ryan Jones used language that many online found offensive. In once ...',
                              link: 'https://www.baltimoresun.com/maryland/harford/aegis/cng-ag-racist-realtor-20200612-possnm52rfh7je43f6jlg7pq7m-story.html',
                              title: 'Harford real estate agent under fire for racially insensitive ...',
                            },
                            {
                              description: 'Jul 3, 2019 - Want to find the best Instagram captions? Whether you like cool captions or need selfie quotes for your photos, you\'ll find a mega list of captions ...',
                              link: 'https://www.oberlo.com/blog/instagram-captions',
                              title: '300+ Best Instagram Captions for Your Photos & Selfies - Oberlo',
                            },
                            {
                              description: 'Mar 24, 2020 - Instagram has launched a new feature called Co-Watching that allows users to share photos and videos over video chat to watch together.',
                              link: 'https://markets.businessinsider.com/news/stocks/instagram-co-watching-feature-group-video-calling-sharing-posts-coronavirus-2020-3-1029027937',
                              title: 'Instagram sped up rollout on its new feature that lets friends ...',
                            },
                            {
                              description: '2 days ago - PRINCE CHARLES last year upped his social media game and posted his first ever photograph to Instagram to commemorate the creation of ...',
                              link: 'https://www.express.co.uk/news/royal/1294044/prince-charles-latest-royal-family-news-instagram-social-media-queen-elizabeth-spt',
                              title: 'Royal landmark: Touching message in Prince Charles\' first ...',
                            },
                            {
                              description: 'marchroute-instagram-1024x1024.png. Privacy Policy | Log In. © American Federation of State, County and Municipal Employees, AFL–CIO.',
                              link: 'https://wfse.org/file/23503',
                              title: 'marchroute-instagram-1024x1024.png | AFSCME at Work',
                            },
                            {
                              description: 'Instagram users can set their privacy settings such that their posted photos and videos are available only to their own followers and require approval from the user ...',
                              link: 'http://acumen.lib.ua.edu/content/u0015/0000001/0002349/u0015_0000001_0002349.pdf',
                              title: 'INDIVIDUAL, TECHNOLOGICAL, SOCIO ... - Acumen',
                            },
                            {
                              description: '8 Nov 2019 — Instagram. “Rethink forgotten and abandoned places; places that have the potential of becoming something better. Refine and transform rather ...',
                              link: 'https://kjellandersjoberg.se/journal/posts/instagram_2172559166213048498_1387743716/74914119_126573782092340_6580899078930915549_n/',
                              title: 'Instagram post of kjellandersjoberg on 2019-11-08 10:34:16 ...',
                            },
                            {
                              description: 'Jul 1, 2016 - This thesis aims to find out how. Leeuwarden and Amsterdam, two cities in the Netherlands, are utilising Instagram by using affordances ...',
                              link: 'https://www.diva-portal.org/smash/get/diva2:1038452/FULLTEXT01.pdf',
                              title: 'City branding on Instagram: DMOs and their usage of ... - DiVA',
                            },
                            {
                              description: 'May 24, 2018 - To achieve this aim a quantitative content analysis of prominent Swedish politicians\' Instagram posts (n=1641) was conducted. The findings show.',
                              link: 'http://lup.lub.lu.se/student-papers/record/8945953/file/8945962.pdf',
                              title: 'Personalisation on Instagram - Lund University Publications',
                            },
                            {
                              description: 'Nov 21, 2016 - Instagram is rolling out new live video and messaging features with a temporary twist.',
                              link: 'https://www.techradar.com/in/news/instagram-has-launched-its-own-take-on-live-video-and-messaging',
                              title: 'Instagram has launched its own take on Live Video and ...',
                            },
                            {
                              description: '“A comparison of Facebook and Instagram concerning emotions regarding, and identification with an automatically generated autobiography”. Deborah Klink.',
                              link: 'http://essay.utwente.nl/78313/1/Klink%20Deborah_BA_PSY.pdf',
                              title: 'Bachelor Thesis “A comparison of Facebook and Instagram ...',
                            },
                            {
                              description: 'Feb 21, 2018 - Styling for Instagram by Leela Cyd, 9782888933502, available at Book Depository with free delivery worldwide.',
                              link: 'https://www.bookdepository.com/Styling-for-Instagram-Leela-Cyd/9782888933502',
                              title: 'Styling for Instagram : Leela Cyd : 9782888933502',
                            },
                            {
                              description: 'Next related hashtags on Instagram used with word muscleup are fit training gymnastics strong strength streetworkout shredded fitfam pullups abs ...',
                              link: 'https://www.tagsfinder.com/en-us/related/muscleup/',
                              title: '#muscleup and related hashtags on Instagram - TagsFinder.com',
                            },
                            {
                              description: '1 day ago - The German company apologized last month for the ad promoting its new Golf 8 and removed it from its official Instagram page. The world\'s ...',
                              link: 'https://ktla.com/news/nationworld/volkswagen-resists-firing-responsible-employees-despite-racist-instagram-ad/',
                              title: 'Volkswagen resists firing responsible employees despite ...',
                            },
                            {
                              description: 'Hangout this or that Instagram Story Templates TEMPLATE STORIES DO INSTAGRAM MINHA QUARENTENA EM GIFS bsf list questions snapchat #bsf #list # ...',
                              link: 'https://www.pinterest.com/amandairyn/instagram-story-template/',
                              title: '16 Best Instagram Story Template images ... - Pinterest',
                            },
                            {
                              description: 'Instagram is the most popular social media platform for influencer marketing (Mohsin, 2019). The platform is mostly used by influencers and consumers who ...',
                              link: 'http://arno.uvt.nl/show.cgi?fid=150748',
                              title: 'Product placement on Instagram - University of Tilburg',
                            },
                            {
                              description: 'Apr 17, 2019 - Tehran, April 17, IRNA - Iran\'s Foreign Ministry spokesman condemned the Instagram social network in blocking accounts of some of the ...',
                              link: 'https://en.irna.ir/news/83282774/Instagram-s-measure-shows-fragility-of-Western-freedom-Spox',
                              title: 'Instagram\'s measure shows fragility of Western freedom: Spox ...',
                            },
                            {
                              description: 'Instagram Wall § - Benjanin Ball La rede det to aoh - Ency King FRANCIS BALL \' S DESCENDANTS . SCENDANTS . 21 . 21 . fully , 96 years of age . Children : 3 ...',
                              link: 'https://books.google.com/books?id=n6wwAAAAMAAJ&pg=PA21&lpg=PA21&dq=instagram&source=bl&ots=jGNZTJ2MuK&sig=ACfU3U2peJK2j-4F3MLjDyRfWMWBZEuZGQ&hl=en&sa=X&ved=2ahUKEwjt3fTus_3pAhXsgnIEHTjKBZcQ6AEwc3oECHEQAQ',
                              title: 'Francis Ball\'s Descendants: Or, The West Springfield Ball ...',
                            },
                            {
                              description: 'Feb 22, 2019 - refer to Instagram posts building upon or reproducing existing copyrighted works. The extent to which UGC must be original to attract copyright ...',
                              link: 'https://heinonline.org/hol-cgi-bin/get_pdf.cgi?handle=hein.journals/saclj31&section=10',
                              title: 'FAIR USE ON INSTAGRAM Transformative Self ... - HeinOnline',
                            },
                            {
                              description: '99 111 total followers. Source: Instagram. Created with Highcharts 5.0.14 Followers Jan 24 Jan 26 Jan 28 Jan 30 0 60,000 120,000. Days Weeks ...',
                              link: 'https://annons.di.se/en-no/influencers/sophia-anderberg-3710/stats/instagram-6066',
                              title: 'Instagram – Sophia Anderberg Statistics - Dagens Industri',
                            },
                            {
                              description: 'Source: Instagram. Created with Highcharts 5.0.14 Followers Apr … Apr 22 Apr 24 Apr 26 Apr 28 Apr 30 May 2 May 4 May 6 May 8 May 10 May 12 May 14 May ...',
                              link: 'http://advertise.bonniermag.se/en/influencers/emily-slotte-2630/stats/instagram-5443',
                              title: 'Instagram – Emily Slotte Statistics',
                            },
                            {
                              description: 'Aug 2, 2016 - He is the first prime minister of the Instagram age. —Andrew-Gee (2016). While Barack Obama partly transformed dynamics of digital politicking in ...',
                              link: 'https://journals.sagepub.com/doi/pdf/10.1177/0002764217744838',
                              title: 'Justin Trudeau, Instagram, and Celebrity Politics - SAGE ...',
                            },
                            {
                              description: 'Jun 29, 2017 - Instagram Download. Instagram ist eine kostenlose App für euer Smartphone – egal ob Android oder iOS. Mit diesen Links könnt ihr Instagram ...',
                              link: 'https://www.giga.de/downloads/instagram/',
                              title: 'Instagram - Giga',
                            },
                            {
                              description: 'INDEX WORDS: admissions, advertising diversity, enrollment management, higher education, Facebook, Instagram, marketing, social media ...',
                              link: 'http://search.proquest.com/openview/89d5556d32104dfcb0bd10ca744824e5/1.pdf?pq-origsite=gscholar&cbl=18750&diss=y',
                              title: 'HIGHER EDUCATION PRIORITIES REFLECTED THROUGH ...',
                            },
                            {
                              description: 'Keywords: Online food photo, Instagram food photo, Intent to visit restaurant,. Perception on price of food, Experimental study. Ref. code: 25616002040811UKW ...',
                              link: 'http://ethesisarchive.library.tu.ac.th/thesis/2018/TU_2018_6002040811_10316_9982.pdf',
                              title: 'how online food photos on instagram influence ... - TU e-Thesis',
                            },
                            {
                              description: 'Mar 23, 2015 - Instagram, LinkedIn, Facebook and Google+, where more personal information was leaked. The tools used are discussed, the results of the ...',
                              link: 'https://www.mdpi.com/1999-5903/7/1/67/pdf',
                              title: 'Download PDF - MDPI',
                            },
                            {
                              description: '... in a newspaper or in handbills , at least one month previous to the day of exhibition . - instagram : Fifth . All articles offered for premiums must be owned 16.',
                              link: 'https://books.google.com/books?id=_ulMAAAAYAAJ&pg=PA16&lpg=PA16&dq=instagram&source=bl&ots=Png5FuqqZQ&sig=ACfU3U0jNcpVhT_oXqjbGx_zmB0honn_lA&hl=en&sa=X&ved=2ahUKEwjt3fTus_3pAhXsgnIEHTjKBZcQ6AEwfHoECHIQAQ',
                              title: 'Annual Report of the Indiana State Board of Agriculture',
                            },
                            {
                              description: 'que en un entorn ace 5 a IN I - Puiululla A r e na instagram Phim TORTEMS y aura leygull dhe s hume selon vin ro " ; W HERE was once an honest gentleman ...',
                              link: 'https://books.google.com/books?id=IP4BAAAAQAAJ&pg=PA61&lpg=PA61&dq=instagram&source=bl&ots=4jV1WgChNM&sig=ACfU3U0mJZ807miNyU33EV3XjibRhKOT6g&hl=en&sa=X&ved=2ahUKEwjt3fTus_3pAhXsgnIEHTjKBZcQ6AEwfXoECHQQAQ',
                              title: 'The old fairy tales [retold]. - Page 61 - Google Books Result',
                            },
                            {
                              description: 'Slate Run , Snow Shoe , Stone , . . . . . . . . . . . . . fontos a : 58 n Forow the ori ca serbest CONAS OO A DONOS X o SPOR OT * * * 200 I \' m going on instagram : .',
                              link: 'https://books.google.com/books?id=XL4WAAAAYAAJ&pg=PA61&lpg=PA61&dq=instagram&source=bl&ots=uvgXITH7Qy&sig=ACfU3U1lFKEffyOIa6D3xQGpqCfvBJAXDA&hl=en&sa=X&ved=2ahUKEwjt3fTus_3pAhXsgnIEHTjKBZcQ6AEwfnoECHMQAQ',
                              title: 'Report of the Department of Forestry of the State of ...',
                            },
                          ],
                          total: 93,
                        },
                      },
                      'search query "google search api"': {
                        value: {
                          answer: null,
                          results: [
                            {
                              description: 'Jun 11, 2019 - The Custom Search JSON API lets you develop websites and applications to retrieve and display search results from Google Custom Search ...',
                              link: 'https://developers.google.com/custom-search/v1/overview',
                              title: 'Custom Search JSON API | Google Developers',
                            },
                            {
                              description: 'As a result, the API provides a single URI that acts as the service endpoint. You can retrieve results for a particular search by sending an HTTP GET request to its ...',
                              link: 'https://developers.google.com/custom-search/v1/using_rest',
                              title: 'Using REST to Invoke the API | Custom Search | Google ...',
                            },
                            {
                              description: 'Apr 8, 2020 - This is the cx parameter used by the API. Identify your application to Google with API key. Custom Search JSON API requires the use of an API ...',
                              link: 'https://developers.google.com/custom-search/v1/introduction',
                              title: 'Custom Search JSON API: Introduction | Google Developers',
                            },
                            {
                              description: 'SerpApi is a real-time API to access Google search results. We handle the issues of having to rent proxies, solving captchas, and parsing rich structured data for ...',
                              link: 'https://serpapi.com/',
                              title: 'SerpApi: Google Search API',
                            },
                            {
                              description: 'Jun 26, 2012 - You could just send them through like a browser does, and then parse the html, that is what I have always done, even for things like Youtube.',
                              link: 'https://stackoverflow.com/questions/4082966/what-are-the-alternatives-now-that-the-google-web-search-api-has-been-deprecated',
                              title: 'What are the alternatives now that the Google web search API ...',
                            },
                            {
                              description: 'Google AJAX Search API is not the same, as it is intended for embedding search results in widgets. Yahoo BOSS is a good example of a search API, even though ...',
                              link: 'https://www.quora.com/Is-there-an-API-for-Google-search-results',
                              title: 'Is there an API for Google search results? - Quora',
                            },
                            {
                              description: 'Jan 22, 2020 - Is There a Google Search API? Google\'s supremacy in search engines is so massive that people often wonder how to scrape data from Google ...',
                              link: 'https://rapidapi.com/blog/google-search-api/',
                              title: 'Google Search API Tutorial: Capture & Record Search Results',
                            },
                            {
                              description: 'Google Search API Documentation. API to perform unlimited Google searches. Learn more about this API. source. POSTpost crawl. search. GETget search.',
                              link: 'https://rapidapi.com/apigeek/api/google-search3',
                              title: 'Google Search API Documentation (apigeek) | RapidAPI',
                            },
                            {
                              description: 'The Google AJAX Search API is designed to make it easier for webmasters and ... site that includes Google Web, Video, News, Maps, and Blog search results.',
                              link: 'https://support.google.com/code/answer/55728?hl=en',
                              title: 'What is the Google AJAX Search API? - Google Developers ...',
                            },
                            {
                              description: 'Nov 9, 2019 - However, as part of this service, Google provides a free Google Search API that that lets you query Google\'s search engine to check search ...',
                              link: 'https://mixedanalytics.com/blog/seo-data-google-custom-search-json-api/',
                              title: 'Get SEO Data with the Google Custom Search JSON API ...',
                            },
                          ],
                          total: 1840000000,
                        },
                      },
                    },
                    schema: {
                      description: 'results',
                      properties: {
                        answer: {
                          type: [
                            'string',
                            'null',
                          ],
                        },
                        results: {
                          items: {
                            properties: {
                              description: {
                                type: 'string',
                              },
                              link: {
                                type: 'string',
                              },
                              title: {
                                type: 'string',
                              },
                            },
                            type: 'object',
                          },
                          type: 'array',
                        },
                        total: {
                          type: [
                            'string',
                            'integer',
                          ],
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Search',
            tags: [
              'Endpoints',
            ],
          },
          parameters: [
            {
              description: 'A url encoded query string, for reference checkout https://moz.com/blog/the-ultimate-guide-to-the-google-search-parameters',
              in: 'path',
              name: 'query',
              required: true,
              schema: {
                type: 'string',
              },
            },
          ],
        },
      },
      security: [
        {
          'API Key': [],
        },
      ],
      servers: [
        {
          url: 'https://ssfy.sh',
        },
      ],
      tags: [
        {
          name: 'Endpoints',
          'x-displayName': 'Endpoints',
        },
      ],
    }

## annotateOpenAPI minimal-http

> Snapshot 1

    {
      components: {
        schemas: {},
        securitySchemes: {
          'API Key': {
            description: `Optional API key for authenticated access.␊
            ␊
            ␊
            Unauthenticated (public) requests are subject to rate limiting. See [pricing](/pricing) for specifics on these rate limits.␊
            ␊
            You can view and manage your API key in the [Dashboard](/dashboard).␊
            ␊
            Be sure to keep your API key secure. Do not share it in publicly accessible areas such as GitHub, client-side code, and so forth.␊
            ␊
            All API requests must be made over HTTPS. Calls made over plain HTTP will fail.`,
            in: 'header',
            name: 'Authorization',
            type: 'apiKey',
          },
        },
      },
      info: {
        contact: {
          email: 'support@saasify.sh',
          name: 'API Support',
        },
        termsOfService: '/terms',
        title: 'minimal-http',
        version: 'v0.1.0',
      },
      openapi: '3.0.2',
      paths: {},
      security: [
        {
          'API Key': [],
        },
      ],
      servers: [
        {
          url: 'https://ssfy.sh',
        },
      ],
      tags: [],
    }

## annotateOpenAPI solder-2

> Snapshot 1

    {
      components: {
        schemas: {
          ChangeableTapTargetData: {
            properties: {
              api_key: {
                title: 'Api Key',
                type: 'string',
              },
              postgres_database: {
                title: 'Postgres Database',
                type: 'string',
              },
              postgres_host: {
                title: 'Postgres Host',
                type: 'string',
              },
              postgres_password: {
                title: 'Postgres Password',
                type: 'string',
              },
              postgres_port: {
                title: 'Postgres Port',
                type: 'integer',
              },
              postgres_schema: {
                title: 'Postgres Schema',
                type: 'string',
              },
              postgres_username: {
                title: 'Postgres Username',
                type: 'string',
              },
              url: {
                title: 'Url',
                type: 'string',
              },
            },
            title: 'ChangeableTapTargetData',
            type: 'object',
          },
          HTTPValidationError: {
            properties: {
              detail: {
                items: {
                  $ref: '#/components/schemas/ValidationError',
                },
                title: 'Detail',
                type: 'array',
              },
            },
            title: 'HTTPValidationError',
            type: 'object',
          },
          TapTargetData: {
            properties: {
              api_key: {
                title: 'Api Key',
                type: 'string',
              },
              postgres_database: {
                title: 'Postgres Database',
                type: 'string',
              },
              postgres_host: {
                title: 'Postgres Host',
                type: 'string',
              },
              postgres_password: {
                title: 'Postgres Password',
                type: 'string',
              },
              postgres_port: {
                title: 'Postgres Port',
                type: 'integer',
              },
              postgres_schema: {
                title: 'Postgres Schema',
                type: 'string',
              },
              postgres_username: {
                title: 'Postgres Username',
                type: 'string',
              },
              url: {
                title: 'Url',
                type: 'string',
              },
            },
            required: [
              'url',
              'api_key',
              'postgres_host',
              'postgres_port',
              'postgres_database',
              'postgres_username',
              'postgres_password',
              'postgres_schema',
            ],
            title: 'TapTargetData',
            type: 'object',
          },
          ValidationError: {
            properties: {
              loc: {
                items: {
                  type: 'string',
                },
                title: 'Location',
                type: 'array',
              },
              msg: {
                title: 'Message',
                type: 'string',
              },
              type: {
                title: 'Error Type',
                type: 'string',
              },
            },
            required: [
              'loc',
              'msg',
              'type',
            ],
            title: 'ValidationError',
            type: 'object',
          },
        },
        securitySchemes: {
          'API Key': {
            description: `Optional API key for authenticated access.␊
            ␊
            ␊
            Unauthenticated (public) requests are subject to rate limiting. See [pricing](/pricing) for specifics on these rate limits.␊
            ␊
            You can view and manage your API key in the [Dashboard](/dashboard).␊
            ␊
            Be sure to keep your API key secure. Do not share it in publicly accessible areas such as GitHub, client-side code, and so forth.␊
            ␊
            All API requests must be made over HTTPS. Calls made over plain HTTP will fail.`,
            in: 'header',
            name: 'Authorization',
            type: 'apiKey',
          },
        },
      },
      info: {
        contact: {
          email: 'mailto:noahsahar@gmail.com',
          name: 'API Support',
        },
        termsOfService: '/terms',
        title: 'soldersh',
        version: 'v1.0.0',
      },
      openapi: '3.0.2',
      paths: {
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/add-data/': {
          post: {
            description: `This endpoint allows the user to add their ActiveCampaign and Postgres data␊
            ␊
            This will allow the user to add their ActiveCampaign and Postgres data.`,
            operationId: 'add_data_activecampaign_postgres_add_data__post',
            parameters: [],
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/TapTargetData',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Add Data',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/end-job/': {
          get: {
            description: `This endpoint will end a current running job if there is one␊
            ␊
            This will allow the user to end a job that they have running.␊
            ␊
            Input:␊
            ␊
            * category: "deals | contacts"`,
            operationId: 'end_job_activecampaign_postgres_end_job__get',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'End Job',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/get-current-running-jobs/': {
          get: {
            description: `Get your current list of running jobs␊
            ␊
            This will let the user retrieve a list of all of his running jobs as well as their current CRON strings.`,
            operationId: 'get_current_running_jobs_activecampaign_postgres_get_current_running_jobs__get',
            parameters: [],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Get Current Running Jobs',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/get-data/': {
          get: {
            description: `This endpoint retrieves the information regarding a current user␊
            ␊
            This will allow the user to retrieve data regarding their ActiveCampaign and Postgres data.`,
            operationId: 'get_data_activecampaign_postgres_get_data__get',
            parameters: [],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Get Data',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/modify-current-job/': {
          put: {
            description: `This endpoint modifies the CRON string of a current running job␊
            ␊
            This will allow the user to modify a job that they have running.␊
            ␊
            Input:␊
            ␊
            * category: "deals | contacts"␊
            * cron: a valid CRON string`,
            operationId: 'modify_current_job_activecampaign_postgres_modify_current_job__put',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'cron',
                required: true,
                schema: {
                  title: 'Cron',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Modify Current Job',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/modify-data/': {
          put: {
            description: `This endpoint allows the user to modify their ActiveCampaign and Postgres data␊
            ␊
            This will allow the user to modify their ActiveCampaign and Postgres data. ␊
            Note that the JSON object below does not have to include every field. It can only include the data you want to change.`,
            operationId: 'modify_data_activecampaign_postgres_modify_data__put',
            parameters: [],
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/ChangeableTapTargetData',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Modify Data',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/perform-etl-all-data/': {
          get: {
            description: `This endpoint allows the user to transfer both their contacts and deals data from ActiveCampaign to Postgres at once␊
            ␊
            This will allow the user to transfer their ActiveCampaign data to Postgres without specifying category.`,
            operationId: 'perform_etl_all_data_activecampaign_postgres_perform_etl_all_data__get',
            parameters: [],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Perform Etl All Data',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/perform-etl-by-category/': {
          get: {
            description: `This endpoint allows the user to perform an ETL transfer between ActiveCampaign and Postgres data by category␊
            ␊
            This will allow the user to transfer their ActiveCampaign data to Postgres by category.␊
            ␊
            Input:␊
            * category: "deals | contacts"`,
            operationId: 'perform_etl_by_category_activecampaign_postgres_perform_etl_by_category__get',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Perform Etl By Category',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/soldersh@cfc693bf/activecampaign-postgres/start-job/': {
          get: {
            description: `This endpoint creates a new job␊
            ␊
            This will allow the user to create an entirely new job if they do not have one running already.␊
            ␊
            Input:␊
            ␊
            * category: "deals | contacts"␊
            * cron: a valid CRON string`,
            operationId: 'start_job_activecampaign_postgres_start_job__get',
            parameters: [
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'cron',
                required: true,
                schema: {
                  title: 'Cron',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Start Job',
            tags: [
              'Endpoints',
            ],
          },
        },
      },
      security: [
        {
          'API Key': [],
        },
      ],
      servers: [
        {
          url: 'https://ssfy.sh',
        },
      ],
      tags: [
        {
          name: 'Endpoints',
          'x-displayName': 'Endpoints',
        },
      ],
    }

## annotateOpenAPI solder-etl

> Snapshot 1

    {
      components: {
        schemas: {
          ChangeableTapTargetData: {
            properties: {
              api_key: {
                title: 'Api Key',
                type: 'string',
              },
              id: {
                title: 'Id',
                type: 'string',
              },
              postgres_database: {
                title: 'Postgres Database',
                type: 'string',
              },
              postgres_host: {
                title: 'Postgres Host',
                type: 'string',
              },
              postgres_password: {
                title: 'Postgres Password',
                type: 'string',
              },
              postgres_port: {
                title: 'Postgres Port',
                type: 'integer',
              },
              postgres_schema: {
                title: 'Postgres Schema',
                type: 'string',
              },
              postgres_username: {
                title: 'Postgres Username',
                type: 'string',
              },
              url: {
                title: 'Url',
                type: 'string',
              },
            },
            required: [
              'id',
            ],
            title: 'ChangeableTapTargetData',
            type: 'object',
          },
          HTTPValidationError: {
            properties: {
              detail: {
                items: {
                  $ref: '#/components/schemas/ValidationError',
                },
                title: 'Detail',
                type: 'array',
              },
            },
            title: 'HTTPValidationError',
            type: 'object',
          },
          TapTargetData: {
            properties: {
              api_key: {
                title: 'Api Key',
                type: 'string',
              },
              postgres_database: {
                title: 'Postgres Database',
                type: 'string',
              },
              postgres_host: {
                title: 'Postgres Host',
                type: 'string',
              },
              postgres_password: {
                title: 'Postgres Password',
                type: 'string',
              },
              postgres_port: {
                title: 'Postgres Port',
                type: 'integer',
              },
              postgres_schema: {
                title: 'Postgres Schema',
                type: 'string',
              },
              postgres_username: {
                title: 'Postgres Username',
                type: 'string',
              },
              url: {
                title: 'Url',
                type: 'string',
              },
            },
            required: [
              'url',
              'api_key',
              'postgres_host',
              'postgres_port',
              'postgres_database',
              'postgres_username',
              'postgres_password',
              'postgres_schema',
            ],
            title: 'TapTargetData',
            type: 'object',
          },
          ValidationError: {
            properties: {
              loc: {
                items: {
                  type: 'string',
                },
                title: 'Location',
                type: 'array',
              },
              msg: {
                title: 'Message',
                type: 'string',
              },
              type: {
                title: 'Error Type',
                type: 'string',
              },
            },
            required: [
              'loc',
              'msg',
              'type',
            ],
            title: 'ValidationError',
            type: 'object',
          },
        },
        securitySchemes: {
          'API Key': {
            description: `Optional API key for authenticated access.␊
            ␊
            ␊
            Unauthenticated (public) requests are subject to rate limiting. See [pricing](/pricing) for specifics on these rate limits.␊
            ␊
            You can view and manage your API key in the [Dashboard](/dashboard).␊
            ␊
            Be sure to keep your API key secure. Do not share it in publicly accessible areas such as GitHub, client-side code, and so forth.␊
            ␊
            All API requests must be made over HTTPS. Calls made over plain HTTP will fail.`,
            in: 'header',
            name: 'Authorization',
            type: 'apiKey',
          },
        },
      },
      info: {
        contact: {
          email: 'support@saasify.sh',
          name: 'API Support',
        },
        termsOfService: '/terms',
        title: 'solder',
        version: 'v0.1.0',
      },
      openapi: '3.0.2',
      paths: {
        '/nhano0228/solder@40433366/activecampaign-postgres/create-user/': {
          post: {
            operationId: 'create_user_activecampaign_postgres_create_user__post',
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/TapTargetData',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Create User',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/end-job/': {
          get: {
            operationId: 'end_job_activecampaign_postgres_end_job__get',
            parameters: [
              {
                in: 'query',
                name: 'uuid',
                required: true,
                schema: {
                  title: 'Uuid',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'End Job',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/get-current-running-jobs/': {
          get: {
            operationId: 'get_current_running_jobs_activecampaign_postgres_get_current_running_jobs__get',
            parameters: [
              {
                in: 'query',
                name: 'uuid',
                required: true,
                schema: {
                  title: 'Uuid',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      Advanced: {
                        description: undefined,
                        summary: 'Advanced',
                        value: {
                          uuid: 'sit velit incid',
                        },
                      },
                      Basic: {
                        description: undefined,
                        summary: 'Basic',
                        value: {
                          uuid: 'fugiat dolore ullamco anim adipisicing',
                        },
                      },
                    },
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Get Current Running Jobs',
            tags: [
              'Endpoints',
            ],
            'x-code-samples': [
              {
                label: 'cURL',
                lang: 'bash',
                source: `curl \\␊
                  'http://localhost:5100/nhano0228/solder@40433366/activecampaign-postgres/get-current-running-jobs/?uuid=fugiat%20dolore%20ullamco%20anim%20adipisicing'`,
              },
              {
                label: 'Node.js',
                lang: 'javascript',
                source: `const request = require('request')␊
                const fs = require('fs')␊
                ␊
                const options = {␊
                  url: 'http://localhost:5100/nhano0228/solder@40433366/activecampaign-postgres/get-current-running-jobs/',␊
                  qs: ,␊
                  json: true␊
                }␊
                ␊
                request(options, (error, response, body) => {␊
                  if (error) throw new Error(error)␊
                ␊
                  console.log(body)␊
                })`,
              },
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/get-user/': {
          get: {
            operationId: 'get_user_activecampaign_postgres_get_user__get',
            parameters: [
              {
                in: 'query',
                name: 'uuid',
                required: true,
                schema: {
                  title: 'Uuid',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      Advanced: {
                        description: undefined,
                        summary: 'Advanced',
                        value: {
                          uuid: 'sit',
                        },
                      },
                    },
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Get User',
            tags: [
              'Endpoints',
            ],
            'x-code-samples': [
              {
                label: 'cURL',
                lang: 'bash',
                source: `curl \\␊
                  'http://localhost:5100/nhano0228/solder@40433366/activecampaign-postgres/get-user/?uuid=sit'`,
              },
              {
                label: 'Node.js',
                lang: 'javascript',
                source: `const request = require('request')␊
                const fs = require('fs')␊
                ␊
                const options = {␊
                  url: 'http://localhost:5100/nhano0228/solder@40433366/activecampaign-postgres/get-user/',␊
                  qs: ,␊
                  json: true␊
                }␊
                ␊
                request(options, (error, response, body) => {␊
                  if (error) throw new Error(error)␊
                ␊
                  console.log(body)␊
                })`,
              },
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/modify-current-job/': {
          post: {
            operationId: 'modify_current_job_activecampaign_postgres_modify_current_job__post',
            parameters: [
              {
                in: 'query',
                name: 'uuid',
                required: true,
                schema: {
                  title: 'Uuid',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'cron',
                required: true,
                schema: {
                  title: 'Cron',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Modify Current Job',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/modify-user/': {
          post: {
            operationId: 'modify_user_activecampaign_postgres_modify_user__post',
            requestBody: {
              content: {
                'application/json': {
                  schema: {
                    $ref: '#/components/schemas/ChangeableTapTargetData',
                  },
                },
              },
              required: true,
            },
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Modify User',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/perform-etl-all-data/': {
          post: {
            operationId: 'perform_etl_all_data_activecampaign_postgres_perform_etl_all_data__post',
            parameters: [
              {
                in: 'query',
                name: 'uuid',
                required: true,
                schema: {
                  title: 'Uuid',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Perform Etl All Data',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/perform-etl-by-category/': {
          post: {
            operationId: 'perform_etl_by_category_activecampaign_postgres_perform_etl_by_category__post',
            parameters: [
              {
                in: 'query',
                name: 'uuid',
                required: true,
                schema: {
                  title: 'Uuid',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Perform Etl By Category',
            tags: [
              'Endpoints',
            ],
          },
        },
        '/nhano0228/solder@40433366/activecampaign-postgres/start-job/': {
          get: {
            operationId: 'start_job_activecampaign_postgres_start_job__get',
            parameters: [
              {
                in: 'query',
                name: 'uuid',
                required: true,
                schema: {
                  title: 'Uuid',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'category',
                required: true,
                schema: {
                  title: 'Category',
                  type: 'string',
                },
              },
              {
                in: 'query',
                name: 'cron',
                required: true,
                schema: {
                  title: 'Cron',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    schema: {},
                  },
                },
                description: 'Successful Response',
              },
              400: {
                description: 'Invalid input',
              },
              422: {
                content: {
                  'application/json': {
                    schema: {
                      $ref: '#/components/schemas/HTTPValidationError',
                    },
                  },
                },
                description: 'Validation Error',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'Start Job',
            tags: [
              'Endpoints',
            ],
          },
        },
      },
      security: [
        {
          'API Key': [],
        },
      ],
      servers: [
        {
          url: 'https://ssfy.sh',
        },
      ],
      tags: [
        {
          name: 'Endpoints',
          'x-displayName': 'Endpoints',
        },
      ],
    }

## annotateOpenAPI synopsis

> Snapshot 1

    {
      components: {
        schemas: {
          SummarizationItem: {
            additionalProperties: false,
            properties: {
              attributionScore: {
                type: 'number',
              },
              index: {
                type: 'number',
              },
              liScore: {
                type: 'number',
              },
              nodeScore: {
                type: 'number',
              },
              readabilityScore: {
                type: 'number',
              },
              score: {
                type: 'number',
              },
              sentence: {
                $ref: '#/components/schemas/SummarizationSentence',
              },
              tfidfScore: {
                type: 'number',
              },
            },
            type: 'object',
          },
          SummarizationResult: {
            additionalProperties: false,
            properties: {
              abstractive: {
                items: {
                  type: 'string',
                },
                type: 'array',
              },
              extractive: {
                items: {
                  type: 'string',
                },
                type: 'array',
              },
              items: {
                items: {
                  $ref: '#/components/schemas/SummarizationItem',
                },
                type: 'array',
              },
              title: {
                type: 'string',
              },
              topItems: {
                items: {
                  $ref: '#/components/schemas/SummarizationItem',
                },
                type: 'array',
              },
            },
            type: 'object',
          },
          SummarizationSentence: {
            additionalProperties: false,
            properties: {
              actual: {
                type: 'string',
              },
              listItem: {
                type: 'number',
              },
              normalized: {
                type: 'string',
              },
              original: {
                type: 'string',
              },
              tokenized: {
                items: {
                  type: 'string',
                },
                type: 'array',
              },
            },
            type: 'object',
          },
        },
        securitySchemes: {
          'API Key': {
            description: `Optional API key for authenticated access.␊
            ␊
            ␊
            Unauthenticated (public) requests are subject to rate limiting. See [pricing](/pricing) for specifics on these rate limits.␊
            ␊
            You can view and manage your API key in the [Dashboard](/dashboard).␊
            ␊
            Be sure to keep your API key secure. Do not share it in publicly accessible areas such as GitHub, client-side code, and so forth.␊
            ␊
            All API requests must be made over HTTPS. Calls made over plain HTTP will fail.`,
            in: 'header',
            name: 'Authorization',
            type: 'apiKey',
          },
        },
      },
      info: {
        contact: {
          email: 'support@saasify.sh',
          name: 'API Support',
        },
        termsOfService: '/terms',
        title: 'synopsis',
        version: 'v1.0.7',
      },
      openapi: '3.0.2',
      paths: {
        '/dev/synopsis@15f060e3/detail': {
          get: {
            description: `Summarizes the content of any `url` or `input` text.␊
            ␊
            Must provide either `url` or `input`.␊
            ␊
            Returns a more verbose description of the summary and intermediary scoring␊
            for all input content.`,
            operationId: 'detailGET',
            parameters: [
              {
                description: 'Link to website to summarize.',
                in: 'query',
                name: 'url',
                schema: {
                  description: 'Link to website to summarize.',
                  example: 'https://www.theonion.com/everyone-involved-in-pizzas-preparation-delivery-purc-1819564897',
                  type: 'string',
                },
              },
              {
                description: 'Text or HTML to summarize.',
                in: 'query',
                name: 'input',
                schema: {
                  description: 'Text or HTML to summarize.',
                  type: 'string',
                },
              },
              {
                description: 'Title of `input` content.',
                in: 'query',
                name: 'title',
                schema: {
                  description: 'Title of `input` content.',
                  type: 'string',
                },
              },
              {
                description: `Optional number of sentences to produce. Default is to␊
                infer a reasonable number based on the input's length.`,
                in: 'query',
                name: 'numSentences',
                schema: {
                  description: `Optional number of sentences to produce. Default is to␊
                  infer a reasonable number based on the input's length.`,
                  type: 'number',
                },
              },
              {
                description: 'Optional minimum number of sentences to produce.',
                in: 'query',
                name: 'minNumSentences',
                schema: {
                  default: 1,
                  description: 'Optional minimum number of sentences to produce.',
                  type: 'number',
                },
              },
              {
                description: 'Optional maximum number of sentences to produce.',
                in: 'query',
                name: 'maxNumSentences',
                schema: {
                  default: 1000,
                  description: 'Optional maximum number of sentences to produce.',
                  type: 'number',
                },
              },
              {
                description: 'Optional minimum image width when considering images in HTML.',
                in: 'query',
                name: 'minImageWidth',
                schema: {
                  default: 400,
                  description: 'Optional minimum image width when considering images in HTML.',
                  type: 'number',
                },
              },
              {
                description: 'Optional minimum image height when considering images in HTML.',
                in: 'query',
                name: 'minImageHeight',
                schema: {
                  default: 300,
                  description: 'Optional minimum image height when considering images in HTML.',
                  type: 'number',
                },
              },
              {
                description: 'Whether or not to consider source media during summarization.',
                in: 'query',
                name: 'media',
                schema: {
                  default: false,
                  description: 'Whether or not to consider source media during summarization.',
                  type: 'boolean',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      'The Onion': {
                        description: undefined,
                        summary: 'The Onion',
                        value: {
                          url: 'https://www.theonion.com/everyone-involved-in-pizzas-preparation-delivery-purc-1819564897',
                        },
                      },
                    },
                    schema: {
                      additionalProperties: false,
                      properties: {
                        abstractive: {
                          items: {
                            type: 'string',
                          },
                          type: 'array',
                        },
                        extractive: {
                          items: {
                            type: 'string',
                          },
                          type: 'array',
                        },
                        items: {
                          items: {
                            $ref: '#/components/schemas/SummarizationItem',
                          },
                          type: 'array',
                        },
                        title: {
                          type: 'string',
                        },
                        topItems: {
                          items: {
                            $ref: '#/components/schemas/SummarizationItem',
                          },
                          type: 'array',
                        },
                      },
                      type: 'object',
                    },
                  },
                },
                description: 'Success',
              },
              400: {
                description: 'Invalid input',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'detail (GET)',
            tags: [
              'Endpoints',
            ],
            'x-code-samples': [
              {
                label: 'cURL',
                lang: 'bash',
                source: `curl \\␊
                  'https://ssfy.sh/dev/synopsis@15f060e3/detail?url=https%3A%2F%2Fwww.theonion.com%2Feveryone-involved-in-pizzas-preparation-delivery-purc-1819564897'`,
              },
              {
                label: 'Node.js',
                lang: 'javascript',
                source: `const request = require('request')␊
                const fs = require('fs')␊
                ␊
                const options = {␊
                  url: 'https://ssfy.sh/dev/synopsis@15f060e3/detail',␊
                  qs: ,␊
                  json: true␊
                }␊
                ␊
                request(options, (error, response, body) => {␊
                  if (error) throw new Error(error)␊
                ␊
                  console.log(body)␊
                })`,
              },
            ],
          },
        },
        '/dev/synopsis@15f060e3/extract': {
          get: {
            description: 'Extracts the main article content from a webpage or article, in addition to lots of useful metadata.',
            operationId: 'extractGET',
            parameters: [
              {
                description: 'Link to website to process.',
                in: 'query',
                name: 'url',
                required: true,
                schema: {
                  description: 'Link to website to process.',
                  example: 'https://www.theonion.com/everyone-involved-in-pizzas-preparation-delivery-purc-1819564897',
                  type: 'string',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      'The Onion': {
                        description: undefined,
                        summary: 'The Onion',
                        value: {
                          url: 'https://www.theonion.com/everyone-involved-in-pizzas-preparation-delivery-purc-1819564897',
                        },
                      },
                    },
                    schema: {
                      additionalProperties: true,
                      properties: {},
                      type: 'object',
                    },
                  },
                },
                description: 'Success',
              },
              400: {
                description: 'Invalid input',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'extract (GET)',
            tags: [
              'Endpoints',
            ],
            'x-code-samples': [
              {
                label: 'cURL',
                lang: 'bash',
                source: `curl \\␊
                  'https://ssfy.sh/dev/synopsis@15f060e3/extract?url=https%3A%2F%2Fwww.theonion.com%2Feveryone-involved-in-pizzas-preparation-delivery-purc-1819564897'`,
              },
              {
                label: 'Node.js',
                lang: 'javascript',
                source: `const request = require('request')␊
                const fs = require('fs')␊
                ␊
                const options = {␊
                  url: 'https://ssfy.sh/dev/synopsis@15f060e3/extract',␊
                  qs: ,␊
                  json: true␊
                }␊
                ␊
                request(options, (error, response, body) => {␊
                  if (error) throw new Error(error)␊
                ␊
                  console.log(body)␊
                })`,
              },
            ],
          },
        },
        '/dev/synopsis@15f060e3/summarize': {
          get: {
            description: `Summarizes the content of any `url` or `input` text.␊
            ␊
            Must provide either `url` or `input`.␊
            ␊
            Returns the summary as an array of strings / sentences.`,
            operationId: 'summarizeGET',
            parameters: [
              {
                description: 'Link to website to summarize.',
                in: 'query',
                name: 'url',
                schema: {
                  description: 'Link to website to summarize.',
                  example: 'https://www.theonion.com/fun-toy-banned-because-of-three-stupid-dead-kids-1819565691',
                  type: 'string',
                },
              },
              {
                description: 'Text or HTML to summarize.',
                in: 'query',
                name: 'input',
                schema: {
                  description: 'Text or HTML to summarize.',
                  type: 'string',
                },
              },
              {
                description: 'Title of `input` content.',
                in: 'query',
                name: 'title',
                schema: {
                  description: 'Title of `input` content.',
                  type: 'string',
                },
              },
              {
                description: `Optional number of sentences to produce. Default is to␊
                infer a reasonable number based on the input's length.`,
                in: 'query',
                name: 'numSentences',
                schema: {
                  description: `Optional number of sentences to produce. Default is to␊
                  infer a reasonable number based on the input's length.`,
                  type: 'number',
                },
              },
              {
                description: 'Optional minimum number of sentences to produce.',
                in: 'query',
                name: 'minNumSentences',
                schema: {
                  default: 1,
                  description: 'Optional minimum number of sentences to produce.',
                  type: 'number',
                },
              },
              {
                description: 'Optional maximum number of sentences to produce.',
                in: 'query',
                name: 'maxNumSentences',
                schema: {
                  default: 1000,
                  description: 'Optional maximum number of sentences to produce.',
                  type: 'number',
                },
              },
              {
                description: 'Optional minimum image width when considering images in HTML.',
                in: 'query',
                name: 'minImageWidth',
                schema: {
                  default: 400,
                  description: 'Optional minimum image width when considering images in HTML.',
                  type: 'number',
                },
              },
              {
                description: 'Optional minimum image height when considering images in HTML.',
                in: 'query',
                name: 'minImageHeight',
                schema: {
                  default: 300,
                  description: 'Optional minimum image height when considering images in HTML.',
                  type: 'number',
                },
              },
              {
                description: 'Whether or not to consider source media during summarization.',
                in: 'query',
                name: 'media',
                schema: {
                  default: false,
                  description: 'Whether or not to consider source media during summarization.',
                  type: 'boolean',
                },
              },
            ],
            responses: {
              200: {
                content: {
                  'application/json': {
                    examples: {
                      'The Onion 1': {
                        description: 'Summarizes an Onion article',
                        summary: 'The Onion 1',
                        value: {
                          url: 'https://www.theonion.com/fun-toy-banned-because-of-three-stupid-dead-kids-1819565691',
                        },
                      },
                      'The Onion 2': {
                        description: 'Summarizes an Onion article',
                        summary: 'The Onion 2',
                        value: {
                          url: 'https://local.theonion.com/plan-to-get-laid-at-dragoncon-2001-fails-1819566152',
                        },
                      },
                      'The Onion 3': {
                        description: 'Summarizes an Onion article',
                        summary: 'The Onion 3',
                        value: {
                          url: 'https://www.theonion.com/everyone-involved-in-pizzas-preparation-delivery-purc-1819564897',
                        },
                      },
                      'Wait But Why': {
                        description: 'Summarizes a blog post',
                        summary: 'Wait But Why',
                        value: {
                          url: 'https://waitbutwhy.com/2015/01/artificial-intelligence-revolution-1.html',
                        },
                      },
                    },
                    schema: {
                      items: {
                        type: 'string',
                      },
                      type: 'array',
                    },
                  },
                },
                description: 'Success',
              },
              400: {
                description: 'Invalid input',
              },
              429: {
                description: 'Rate limit exceeded',
              },
            },
            summary: 'summarize (GET)',
            tags: [
              'Endpoints',
            ],
            'x-code-samples': [
              {
                label: 'cURL',
                lang: 'bash',
                source: `curl \\␊
                  'https://ssfy.sh/dev/synopsis@15f060e3/summarize?url=https%3A%2F%2Fwww.theonion.com%2Ffun-toy-banned-because-of-three-stupid-dead-kids-1819565691'`,
              },
              {
                label: 'Node.js',
                lang: 'javascript',
                source: `const request = require('request')␊
                const fs = require('fs')␊
                ␊
                const options = {␊
                  url: 'https://ssfy.sh/dev/synopsis@15f060e3/summarize',␊
                  qs: ,␊
                  json: true␊
                }␊
                ␊
                request(options, (error, response, body) => {␊
                  if (error) throw new Error(error)␊
                ␊
                  console.log(body)␊
                })`,
              },
            ],
          },
        },
      },
      security: [
        {
          'API Key': [],
        },
      ],
      servers: [
        {
          url: 'https://ssfy.sh',
        },
      ],
      tags: [
        {
          name: 'Endpoints',
          'x-displayName': 'Endpoints',
        },
      ],
    }
