[header](_header.md ':include')

# Use Cases

Any externally hosted REST API can potentially be monetized via Saasify.

Here are some example use cases to get the gears turning...

## Low/No-code workflows

- Google Sheets to X
- Notion to X
- Airable to X

## Workflow automation

- Headless Chrome
- Bots
- Scraping
- Automating social media accounts

## Image & media processing tasks

- Meme generation
- Image / gif / video optimization
- Fun image effects

## Data transformations

- Document conversions (docx => pdf, video => gif, etc)
- IP address to metadata lookup
- User profile enrichment (email or domain => user information)
- Offering paid access to proprietary datasets

## Misc

- Developer tools
- General algorithms
- Pre-built machine learning models
- Your NPM module or PyPI package?
  - Offering a hosted, paid version of your OSS work can be a great way to sustain yourself as an indie developer.
  - This is commonly known as an [open core](https://coss.media/open-core-definition-examples-tradeoffs/) business model.

## Your ideas!

Have an idea for a product that you'd like to monetize, but not sure where to start? Feel free to [get in touch](support.md). In addition to our core team, we have an active community of passionate indie makers just like you who love helping like-minded entrepreneurs.

!> You should also check out our growing list of [examples](examples.md) and external [resources](resources.md) for additional inspiration.
