[header](_header.md ':include')

# Resources

Saasify is great for quickly bringing your SaaS ideas to market, but what if you don't have an idea? How do you validate that an idea is worth working on? And what's the best way to market your product once it's ready to launch?

These are all excellent questions that profitable SaaS businesses will have to answer at some point.

In the future, Saasify's goal is to help answer some of these questions for you, but in the meantime we've rounded up some of the best free resources for every step along your SaaS journey.

## General Resources

- [Free Resources for Indie SaaS Devs](https://blog.saasify.sh/indie-saas-resources/) - Our own breakdown of the best free resources for developers bootstrapping indie SaaS businesses in 2020. 🔥
- [Indie Hackers Guide](https://www.indiehackers.com/start) - An excellent guide to building your own profitable side projects by Indie Hackers.
- [Micro SaaS E-book](https://tylertringas.com/micro-saas-ebook/) - Free e-book about bootstrapping profitable "Micro SaaS" businesses which fits Saasify's model really well.

## SaaS Idea Resources

- [Top Zapier Apps](https://zapier.com/apps) - Zapier is a really solid platform for no-code workflows. There are many cases where you could take a specific Zapier workflow and build a standalone, niche SaaS product that focuses on supporting that one flow really well.
  - [Top Zapier integrations](https://zapier.com/apps/integrations/)
- [Parabola recipes](https://parabola.io/recipes) - Curated list of workflow ideas that would make great Micro SaaS products.
- [GitHub Actions](https://github.com/features/actions) - Lots of solid ideas for niche developer tool automations that could work well as Micro SaaS products.
- [Top Dashdash integrations](https://dashdash.com/integrations) - Dashdash is similar to Zapier and their list of featured integrations is a great place to gather inspiration.
- [SaaSHub](https://www.saashub.com/) - Curated collection of existing SaaS products.
- [Machine Learning Models](https://ludwig-ai.github.io/ludwig-docs/examples/) - Curated collection of pre-built machine learning models from Uber.
- [Automation ideas](https://phantombuster.com/phantombuster) - Validated, niche automation product ideas.

!> **Don't worry if there are existing products and solutions that offer similar functionality to your SaaS idea**. This is actually a really good thing because it helps to validate that there is a market willing to pay for your product! Competitive research is an important part of building a successful SaaS product, and understanding the landscape of existing solutions will help you narrow down your unique value proposition and find gaps in the market.

## API Resources

- [Top public APIs](https://public-apis.xyz/) - Great collection of existing public APIs for everything from movies, weather, food, music, memes, news, etc.
- [API List](https://apilist.fun/) - Large list of OpenAPIs.
- [Public APIs](https://github.com/public-apis/public-apis) - Large list of public APIs for all sorts of use cases.
- [APIs Guru](https://apis.guru/browse-apis/) - Large list of OpenAPIs.
